/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.dispatch.host;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.extract.base.utils.Host;
import org.apache.dolphinscheduler.server.master.dispatch.exceptions.WorkerGroupNotFoundException;
import org.apache.dolphinscheduler.server.master.dispatch.host.HostManager;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.HostWorker;
import org.apache.dolphinscheduler.server.master.registry.ServerNodeManager;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CommonHostManager
implements HostManager {
    @Autowired
    protected ServerNodeManager serverNodeManager;

    @Override
    public Optional<Host> select(String workerGroup) throws WorkerGroupNotFoundException {
        List<HostWorker> candidates = this.getWorkerCandidates(workerGroup);
        if (CollectionUtils.isEmpty(candidates)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.select(candidates));
    }

    protected abstract HostWorker select(Collection<HostWorker> var1);

    protected List<HostWorker> getWorkerCandidates(String workerGroup) throws WorkerGroupNotFoundException {
        ArrayList<HostWorker> hostWorkers = new ArrayList<HostWorker>();
        Set<String> nodes = this.serverNodeManager.getWorkerGroupNodes(workerGroup);
        if (CollectionUtils.isNotEmpty(nodes)) {
            for (String node : nodes) {
                this.serverNodeManager.getWorkerNodeInfo(node).ifPresent(workerNodeInfo -> hostWorkers.add(HostWorker.of(node, workerNodeInfo.getWorkerHostWeight(), workerGroup)));
            }
        }
        return hostWorkers;
    }
}

