/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.dispatch.host.assign;

import lombok.Generated;
import org.apache.dolphinscheduler.extract.base.utils.Host;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.HostWorker;

public class HostWeight {
    private final int THREAD_USAGE_FACTOR = 10;
    private final int CPU_USAGE_FACTOR = 20;
    private final int MEMORY_USAGE_FACTOR = 20;
    private final int DISK_USAGE_FACTOR = 50;
    private final Host host;
    private final double weight;
    private double currentWeight;

    public HostWeight(HostWorker hostWorker, double cpuUsage, double memoryUsage, double diskUsage, double threadPoolUsage, long startTime) {
        this.host = hostWorker;
        this.currentWeight = this.weight = this.calculateWeight(cpuUsage, memoryUsage, diskUsage, threadPoolUsage, startTime);
    }

    private double calculateWeight(double cpuUsage, double memoryUsage, double diskUsage, double threadPoolUsage, long startTime) {
        double calculatedWeight = 100.0 - (cpuUsage * 20.0 + memoryUsage * 20.0 + diskUsage * 50.0 + threadPoolUsage * 10.0);
        long uptime = System.currentTimeMillis() - startTime;
        if (uptime > 0L && uptime < 600000L) {
            return calculatedWeight * 600000.0 / (double)uptime;
        }
        return calculatedWeight;
    }

    @Generated
    public int getTHREAD_USAGE_FACTOR() {
        return this.THREAD_USAGE_FACTOR;
    }

    @Generated
    public int getCPU_USAGE_FACTOR() {
        this.getClass();
        return 20;
    }

    @Generated
    public int getMEMORY_USAGE_FACTOR() {
        this.getClass();
        return 20;
    }

    @Generated
    public int getDISK_USAGE_FACTOR() {
        return this.DISK_USAGE_FACTOR;
    }

    @Generated
    public Host getHost() {
        return this.host;
    }

    @Generated
    public double getWeight() {
        return this.weight;
    }

    @Generated
    public double getCurrentWeight() {
        return this.currentWeight;
    }

    @Generated
    public void setCurrentWeight(double currentWeight) {
        this.currentWeight = currentWeight;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HostWeight)) {
            return false;
        }
        HostWeight other = (HostWeight)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTHREAD_USAGE_FACTOR() != other.getTHREAD_USAGE_FACTOR()) {
            return false;
        }
        if (this.getCPU_USAGE_FACTOR() != other.getCPU_USAGE_FACTOR()) {
            return false;
        }
        if (this.getMEMORY_USAGE_FACTOR() != other.getMEMORY_USAGE_FACTOR()) {
            return false;
        }
        if (this.getDISK_USAGE_FACTOR() != other.getDISK_USAGE_FACTOR()) {
            return false;
        }
        if (Double.compare(this.getWeight(), other.getWeight()) != 0) {
            return false;
        }
        if (Double.compare(this.getCurrentWeight(), other.getCurrentWeight()) != 0) {
            return false;
        }
        Host this$host = this.getHost();
        Host other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HostWeight;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTHREAD_USAGE_FACTOR();
        result = result * 59 + this.getCPU_USAGE_FACTOR();
        result = result * 59 + this.getMEMORY_USAGE_FACTOR();
        result = result * 59 + this.getDISK_USAGE_FACTOR();
        long $weight = Double.doubleToLongBits(this.getWeight());
        result = result * 59 + (int)($weight >>> 32 ^ $weight);
        long $currentWeight = Double.doubleToLongBits(this.getCurrentWeight());
        result = result * 59 + (int)($currentWeight >>> 32 ^ $currentWeight);
        Host $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HostWeight(THREAD_USAGE_FACTOR=" + this.getTHREAD_USAGE_FACTOR() + ", CPU_USAGE_FACTOR=" + this.getCPU_USAGE_FACTOR() + ", MEMORY_USAGE_FACTOR=" + this.getMEMORY_USAGE_FACTOR() + ", DISK_USAGE_FACTOR=" + this.getDISK_USAGE_FACTOR() + ", host=" + this.getHost() + ", weight=" + this.getWeight() + ", currentWeight=" + this.getCurrentWeight() + ")";
    }
}

