/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.event;

import com.google.auto.service.AutoService;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.event.StateEventHandleError;
import org.apache.dolphinscheduler.server.master.event.StateEventHandleException;
import org.apache.dolphinscheduler.server.master.event.StateEventHandler;
import org.apache.dolphinscheduler.server.master.event.TaskStateEvent;
import org.apache.dolphinscheduler.server.master.metrics.TaskMetrics;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={StateEventHandler.class})
public class TaskStateEventHandler
implements StateEventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskStateEventHandler.class);

    @Override
    public boolean handleStateEvent(WorkflowExecuteRunnable workflowExecuteRunnable, StateEvent stateEvent) throws StateEventHandleException, StateEventHandleError {
        TaskStateEvent taskStateEvent = (TaskStateEvent)stateEvent;
        this.measureTaskState(taskStateEvent);
        workflowExecuteRunnable.checkTaskInstanceByStateEvent(taskStateEvent);
        Optional<TaskInstance> taskInstanceOptional = workflowExecuteRunnable.getTaskInstance(taskStateEvent.getTaskInstanceId());
        TaskInstance task = taskInstanceOptional.orElseThrow(() -> new StateEventHandleError("Cannot find task instance from taskMap by task instance id: " + taskStateEvent.getTaskInstanceId()));
        if (task.getState() == null) {
            throw new StateEventHandleError("Task state event handle error due to task state is null");
        }
        log.info("Handle task instance state event, the current task instance state {} will be changed to {}", (Object)task.getState().name(), (Object)taskStateEvent.getStatus().name());
        if (taskStateEvent.getStatus().isRunning()) {
            workflowExecuteRunnable.taskStart(task);
        }
        Set<Long> completeTaskSet = workflowExecuteRunnable.getCompleteTaskCodes();
        if (task.getState().isFinished() && taskStateEvent.getStatus() != null && taskStateEvent.getStatus().isRunning()) {
            String errorMessage = String.format("The current TaskInstance: %s state is %s, but the task state event status is %s, so the task state event will be ignored", task.getName(), task.getState().name(), taskStateEvent.getStatus().name());
            log.warn(errorMessage);
            throw new StateEventHandleError(errorMessage);
        }
        if (task.getState().isFinished()) {
            if (completeTaskSet.contains(task.getTaskCode())) {
                log.warn("The task instance is already complete, stateEvent: {}", (Object)stateEvent);
                return true;
            }
            workflowExecuteRunnable.taskFinished(task);
            return true;
        }
        return true;
    }

    @Override
    public StateEventType getEventType() {
        return StateEventType.TASK_STATE_CHANGE;
    }

    private void measureTaskState(TaskStateEvent taskStateEvent) {
        if (taskStateEvent == null || taskStateEvent.getStatus() == null) {
            log.warn("The task event is broken..., taskEvent: {}", (Object)taskStateEvent);
            return;
        }
        if (taskStateEvent.getStatus().isFinished()) {
            TaskMetrics.incTaskInstanceByState("finish");
        }
        switch (taskStateEvent.getStatus()) {
            case KILL: {
                TaskMetrics.incTaskInstanceByState("stop");
                break;
            }
            case SUCCESS: {
                TaskMetrics.incTaskInstanceByState("success");
                break;
            }
            case FAILURE: {
                TaskMetrics.incTaskInstanceByState("fail");
                break;
            }
        }
    }
}

