/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.event;

import java.util.Optional;
import org.apache.dolphinscheduler.common.enums.TaskEventType;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.dao.utils.TaskInstanceUtils;
import org.apache.dolphinscheduler.extract.base.client.SingletonJdkDynamicRpcClientProxyFactory;
import org.apache.dolphinscheduler.extract.worker.ITaskInstanceExecutionEventAckListener;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstanceExecutionInfoEventAck;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.event.TaskEventHandleError;
import org.apache.dolphinscheduler.server.master.event.TaskEventHandler;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEvent;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThreadPool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskUpdatePidEventHandler
implements TaskEventHandler {
    @Autowired
    private ProcessInstanceExecCacheManager processInstanceExecCacheManager;
    @Autowired
    private WorkflowExecuteThreadPool workflowExecuteThreadPool;
    @Autowired
    private TaskInstanceDao taskInstanceDao;

    @Override
    public void handleTaskEvent(TaskEvent taskEvent) throws TaskEventHandleError {
        int taskInstanceId = taskEvent.getTaskInstanceId();
        int processInstanceId = taskEvent.getProcessInstanceId();
        WorkflowExecuteRunnable workflowExecuteRunnable = this.processInstanceExecCacheManager.getByProcessInstanceId(processInstanceId);
        if (workflowExecuteRunnable == null) {
            this.sendAckToWorker(taskEvent);
            throw new TaskEventHandleError("Handle task running event error, cannot find related workflow instance from cache, will discard this event");
        }
        Optional<TaskInstance> taskInstanceOptional = workflowExecuteRunnable.getTaskInstance(taskInstanceId);
        if (!taskInstanceOptional.isPresent()) {
            this.sendAckToWorker(taskEvent);
            throw new TaskEventHandleError("Handle running event error, cannot find the taskInstance from cache, will discord this event");
        }
        TaskInstance taskInstance = taskInstanceOptional.get();
        if (taskInstance.getState().isFinished()) {
            this.sendAckToWorker(taskEvent);
            throw new TaskEventHandleError("Handle task running event error, this task instance is already finished, this event is delay, will discard this event");
        }
        TaskInstance oldTaskInstance = new TaskInstance();
        TaskInstanceUtils.copyTaskInstance((TaskInstance)taskInstance, (TaskInstance)oldTaskInstance);
        try {
            taskInstance.setStartTime(taskEvent.getStartTime());
            taskInstance.setHost(taskEvent.getWorkerAddress());
            taskInstance.setPid(taskEvent.getProcessId());
            if (!this.taskInstanceDao.updateById((Object)taskInstance)) {
                throw new TaskEventHandleError("Handle task running event error, update taskInstance to db failed");
            }
            this.sendAckToWorker(taskEvent);
        }
        catch (Exception ex) {
            TaskInstanceUtils.copyTaskInstance((TaskInstance)oldTaskInstance, (TaskInstance)taskInstance);
            if (ex instanceof TaskEventHandleError) {
                throw ex;
            }
            throw new TaskEventHandleError("Handle task update pid  event error, update taskInstance to db failed", ex);
        }
    }

    private void sendAckToWorker(TaskEvent taskEvent) {
        ITaskInstanceExecutionEventAckListener instanceExecutionEventAckListener = (ITaskInstanceExecutionEventAckListener)SingletonJdkDynamicRpcClientProxyFactory.getProxyClient((String)taskEvent.getWorkerAddress(), ITaskInstanceExecutionEventAckListener.class);
        instanceExecutionEventAckListener.handleTaskInstanceExecutionInfoEventAck(TaskInstanceExecutionInfoEventAck.success((int)taskEvent.getTaskInstanceId()));
    }

    @Override
    public TaskEventType getHandleEventType() {
        return TaskEventType.UPDATE_PID;
    }
}

