/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.event;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.event.WorkflowEvent;
import org.apache.dolphinscheduler.server.master.event.WorkflowEventHandleError;
import org.apache.dolphinscheduler.server.master.event.WorkflowEventHandler;
import org.apache.dolphinscheduler.server.master.event.WorkflowEventType;
import org.apache.dolphinscheduler.server.master.event.WorkflowStateEvent;
import org.apache.dolphinscheduler.server.master.metrics.ProcessInstanceMetrics;
import org.apache.dolphinscheduler.server.master.runner.StateWheelExecuteThread;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThreadPool;
import org.apache.dolphinscheduler.server.master.runner.WorkflowStartStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowStartEventHandler
implements WorkflowEventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowStartEventHandler.class);
    @Autowired
    private ProcessInstanceExecCacheManager processInstanceExecCacheManager;
    @Autowired
    private StateWheelExecuteThread stateWheelExecuteThread;
    @Autowired
    private WorkflowExecuteThreadPool workflowExecuteThreadPool;

    @Override
    public void handleWorkflowEvent(WorkflowEvent workflowEvent) throws WorkflowEventHandleError {
        log.info("Handle workflow start event, begin to start a workflow, event: {}", (Object)workflowEvent);
        WorkflowExecuteRunnable workflowExecuteRunnable = this.processInstanceExecCacheManager.getByProcessInstanceId(workflowEvent.getWorkflowInstanceId());
        if (workflowExecuteRunnable == null) {
            throw new WorkflowEventHandleError("The workflow start event is invalid, cannot find the workflow instance from cache");
        }
        ProcessInstance processInstance = workflowExecuteRunnable.getWorkflowExecuteContext().getWorkflowInstance();
        ProcessInstanceMetrics.incProcessInstanceByStateAndProcessDefinitionCode("submit", processInstance.getProcessDefinitionCode().toString());
        CompletableFuture.supplyAsync(workflowExecuteRunnable::call, (Executor)((Object)this.workflowExecuteThreadPool)).thenAccept(workflowStartStatus -> {
            if (WorkflowStartStatus.SUCCESS == workflowStartStatus) {
                log.info("Success submit the workflow instance");
                if (processInstance.getTimeout() > 0) {
                    this.stateWheelExecuteThread.addProcess4TimeoutCheck(processInstance);
                }
            } else if (WorkflowStartStatus.FAILED == workflowStartStatus) {
                log.error("Failed to submit the workflow instance, will send fail state event: {}", (Object)workflowEvent);
                WorkflowStateEvent stateEvent = WorkflowStateEvent.builder().processInstanceId(processInstance.getId()).type(StateEventType.PROCESS_SUBMIT_FAILED).status(WorkflowExecutionStatus.FAILURE).build();
                workflowExecuteRunnable.addStateEvent(stateEvent);
            }
        });
    }

    @Override
    public WorkflowEventType getHandleWorkflowEventType() {
        return WorkflowEventType.START_WORKFLOW;
    }
}

