/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.event;

import com.google.auto.service.AutoService;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.event.StateEventHandleException;
import org.apache.dolphinscheduler.server.master.event.StateEventHandler;
import org.apache.dolphinscheduler.server.master.event.WorkflowStateEvent;
import org.apache.dolphinscheduler.server.master.metrics.ProcessInstanceMetrics;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={StateEventHandler.class})
public class WorkflowStateEventHandler
implements StateEventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowStateEventHandler.class);

    @Override
    public boolean handleStateEvent(WorkflowExecuteRunnable workflowExecuteRunnable, StateEvent stateEvent) throws StateEventHandleException {
        WorkflowStateEvent workflowStateEvent = (WorkflowStateEvent)stateEvent;
        ProcessInstance processInstance = workflowExecuteRunnable.getWorkflowExecuteContext().getWorkflowInstance();
        ProcessDefinition processDefinition = processInstance.getProcessDefinition();
        this.measureProcessState(workflowStateEvent, processInstance.getProcessDefinitionCode().toString());
        log.info("Handle workflow instance state event, the current workflow instance state {} will be changed to {}", (Object)processInstance.getState(), (Object)workflowStateEvent.getStatus());
        if (workflowStateEvent.getStatus().isStop()) {
            if (processDefinition.getExecutionType().typeIsSerialWait() || processDefinition.getExecutionType().typeIsSerialPriority()) {
                workflowExecuteRunnable.endProcess();
                return true;
            }
            workflowExecuteRunnable.updateProcessInstanceState(workflowStateEvent);
            return true;
        }
        if (workflowExecuteRunnable.processComplementData()) {
            return true;
        }
        if (workflowStateEvent.getStatus().isFinished()) {
            if (workflowStateEvent.getType().equals((Object)StateEventType.PROCESS_SUBMIT_FAILED)) {
                workflowExecuteRunnable.updateProcessInstanceState(workflowStateEvent);
            }
            workflowExecuteRunnable.endProcess();
        }
        if (workflowStateEvent.getStatus().isReadyStop()) {
            workflowExecuteRunnable.refreshProcessInstance(processInstance.getId());
            if (processInstance.getState().isReadyStop()) {
                workflowExecuteRunnable.killAllTasks();
            }
        }
        return true;
    }

    @Override
    public StateEventType getEventType() {
        return StateEventType.PROCESS_STATE_CHANGE;
    }

    private void measureProcessState(WorkflowStateEvent processStateEvent, String processDefinitionCode) {
        if (processStateEvent.getStatus().isFinished()) {
            ProcessInstanceMetrics.incProcessInstanceByStateAndProcessDefinitionCode("finish", processDefinitionCode);
        }
        switch (processStateEvent.getStatus()) {
            case STOP: {
                ProcessInstanceMetrics.incProcessInstanceByStateAndProcessDefinitionCode("stop", processDefinitionCode);
                break;
            }
            case SUCCESS: {
                ProcessInstanceMetrics.incProcessInstanceByStateAndProcessDefinitionCode("success", processDefinitionCode);
                break;
            }
            case FAILURE: {
                ProcessInstanceMetrics.incProcessInstanceByStateAndProcessDefinitionCode("fail", processDefinitionCode);
                break;
            }
        }
    }
}

