/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.event;

import com.google.auto.service.AutoService;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.event.StateEventHandler;
import org.apache.dolphinscheduler.server.master.metrics.ProcessInstanceMetrics;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={StateEventHandler.class})
public class WorkflowTimeoutStateEventHandler
implements StateEventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowTimeoutStateEventHandler.class);

    @Override
    public boolean handleStateEvent(WorkflowExecuteRunnable workflowExecuteRunnable, StateEvent stateEvent) {
        log.info("Handle workflow instance timeout event");
        ProcessInstance processInstance = workflowExecuteRunnable.getWorkflowExecuteContext().getWorkflowInstance();
        ProcessInstanceMetrics.incProcessInstanceByStateAndProcessDefinitionCode("timeout", processInstance.getProcessDefinitionCode().toString());
        workflowExecuteRunnable.processTimeout();
        return true;
    }

    @Override
    public StateEventType getEventType() {
        return StateEventType.PROCESS_TIMEOUT;
    }
}

