/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionLogDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.server.master.graph.IWorkflowGraph;
import org.apache.dolphinscheduler.server.master.graph.WorkflowGraph;
import org.apache.dolphinscheduler.service.model.TaskNode;
import org.apache.dolphinscheduler.service.process.ProcessDag;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.utils.DagHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowGraphFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowGraphFactory.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private TaskInstanceDao taskInstanceDao;
    @Autowired
    private TaskDefinitionLogDao taskDefinitionLogDao;

    public IWorkflowGraph createWorkflowGraph(ProcessInstance workflowInstance) throws Exception {
        List processTaskRelations = this.processService.findRelationByCode(workflowInstance.getProcessDefinitionCode().longValue(), workflowInstance.getProcessDefinitionVersion());
        List taskDefinitionLogs = this.taskDefinitionLogDao.queryTaskDefineLogList(processTaskRelations);
        List taskNodeList = this.processService.transformTask(processTaskRelations, taskDefinitionLogs);
        List<Long> recoveryTaskNodeCodeList = this.getRecoveryTaskNodeCodeList(workflowInstance.getCommandParam());
        List<Long> startNodeNameList = this.parseStartNodeName(workflowInstance.getCommandParam());
        ProcessDag processDag = DagHelper.generateFlowDag((List)taskNodeList, startNodeNameList, recoveryTaskNodeCodeList, (TaskDependType)workflowInstance.getTaskDependType());
        if (processDag == null) {
            log.error("ProcessDag is null");
            throw new IllegalArgumentException("Create WorkflowGraph failed, ProcessDag is null");
        }
        DAG dagGraph = DagHelper.buildDagGraph((ProcessDag)processDag);
        log.debug("Build dag success, dag: {}", (Object)dagGraph);
        return new WorkflowGraph(taskNodeList, (DAG<Long, TaskNode, TaskNodeRelation>)dagGraph);
    }

    private List<Long> getRecoveryTaskNodeCodeList(String cmdParam) {
        List startTaskInstanceIds;
        Map paramMap = JSONUtils.toMap((String)cmdParam);
        if (paramMap != null && paramMap.containsKey("StartNodeIdList") && CollectionUtils.isNotEmpty(startTaskInstanceIds = Arrays.stream(((String)paramMap.get("StartNodeIdList")).split(",")).filter(StringUtils::isNotEmpty).map(Integer::valueOf).collect(Collectors.toList()))) {
            return this.taskInstanceDao.queryByIds(startTaskInstanceIds).stream().map(TaskInstance::getTaskCode).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<Long> parseStartNodeName(String cmdParam) {
        List<Long> startNodeNameList = new ArrayList<Long>();
        Map paramMap = JSONUtils.toMap((String)cmdParam);
        if (paramMap == null) {
            return startNodeNameList;
        }
        if (paramMap.containsKey("StartNodeList")) {
            startNodeNameList = Arrays.asList(((String)paramMap.get("StartNodeList")).split(",")).stream().map(String::trim).map(Long::valueOf).collect(Collectors.toList());
        }
        return startNodeNameList;
    }
}

