/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor.queue;

import java.util.Date;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.TaskEventType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.extract.master.transportor.TaskInstanceExecutionFinishEvent;
import org.apache.dolphinscheduler.extract.master.transportor.TaskInstanceExecutionInfoEvent;
import org.apache.dolphinscheduler.extract.master.transportor.TaskInstanceExecutionRunningEvent;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;

public class TaskEvent {
    private int taskInstanceId;
    private String workerAddress;
    private TaskExecutionStatus state;
    private Date startTime;
    private Date endTime;
    private String executePath;
    private String logPath;
    private int processId;
    private String appIds;
    private TaskEventType event;
    private String varPool;
    private int cacheTaskInstanceId;
    private int processInstanceId;

    public static TaskEvent newDispatchEvent(int processInstanceId, int taskInstanceId, String workerAddress) {
        TaskEvent event = new TaskEvent();
        event.setProcessInstanceId(processInstanceId);
        event.setTaskInstanceId(taskInstanceId);
        event.setWorkerAddress(workerAddress);
        event.setEvent(TaskEventType.DISPATCH);
        return event;
    }

    public static TaskEvent newRunningEvent(TaskInstanceExecutionRunningEvent command) {
        TaskEvent event = new TaskEvent();
        event.setProcessInstanceId(command.getProcessInstanceId());
        event.setTaskInstanceId(command.getTaskInstanceId());
        event.setState(command.getStatus());
        event.setStartTime(DateUtils.timeStampToDate((long)command.getStartTime()));
        event.setExecutePath(command.getExecutePath());
        event.setLogPath(command.getLogPath());
        event.setAppIds(command.getAppIds());
        event.setWorkerAddress(command.getTaskInstanceHost());
        event.setEvent(TaskEventType.RUNNING);
        return event;
    }

    public static TaskEvent newResultEvent(TaskInstanceExecutionFinishEvent command) {
        TaskEvent event = new TaskEvent();
        event.setProcessInstanceId(command.getProcessInstanceId());
        event.setTaskInstanceId(command.getTaskInstanceId());
        event.setState(TaskExecutionStatus.of((int)command.getStatus()));
        event.setStartTime(DateUtils.timeStampToDate((long)command.getStartTime()));
        event.setExecutePath(command.getExecutePath());
        event.setLogPath(command.getLogPath());
        event.setEndTime(DateUtils.timeStampToDate((long)command.getEndTime()));
        event.setProcessId(command.getProcessId());
        event.setAppIds(command.getAppIds());
        event.setVarPool(command.getVarPool());
        event.setWorkerAddress(command.getTaskInstanceHost());
        event.setEvent(TaskEventType.RESULT);
        return event;
    }

    public static TaskEvent newCacheEvent(int processInstanceId, int taskInstanceId, int cacheTaskInstanceId) {
        TaskEvent event = new TaskEvent();
        event.setProcessInstanceId(processInstanceId);
        event.setTaskInstanceId(taskInstanceId);
        event.setCacheTaskInstanceId(cacheTaskInstanceId);
        event.setEvent(TaskEventType.CACHE);
        return event;
    }

    public static TaskEvent newUpdatePidEvent(TaskInstanceExecutionInfoEvent command) {
        TaskEvent event = new TaskEvent();
        event.setProcessInstanceId(command.getProcessInstanceId());
        event.setTaskInstanceId(command.getTaskInstanceId());
        event.setStartTime(DateUtils.timeStampToDate((long)command.getStartTime()));
        event.setLogPath(command.getLogPath());
        event.setWorkerAddress(command.getTaskInstanceHost());
        event.setEvent(TaskEventType.UPDATE_PID);
        return event;
    }

    @Generated
    public static TaskEventBuilder builder() {
        return new TaskEventBuilder();
    }

    @Generated
    public int getTaskInstanceId() {
        return this.taskInstanceId;
    }

    @Generated
    public String getWorkerAddress() {
        return this.workerAddress;
    }

    @Generated
    public TaskExecutionStatus getState() {
        return this.state;
    }

    @Generated
    public Date getStartTime() {
        return this.startTime;
    }

    @Generated
    public Date getEndTime() {
        return this.endTime;
    }

    @Generated
    public String getExecutePath() {
        return this.executePath;
    }

    @Generated
    public String getLogPath() {
        return this.logPath;
    }

    @Generated
    public int getProcessId() {
        return this.processId;
    }

    @Generated
    public String getAppIds() {
        return this.appIds;
    }

    @Generated
    public TaskEventType getEvent() {
        return this.event;
    }

    @Generated
    public String getVarPool() {
        return this.varPool;
    }

    @Generated
    public int getCacheTaskInstanceId() {
        return this.cacheTaskInstanceId;
    }

    @Generated
    public int getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Generated
    public void setTaskInstanceId(int taskInstanceId) {
        this.taskInstanceId = taskInstanceId;
    }

    @Generated
    public void setWorkerAddress(String workerAddress) {
        this.workerAddress = workerAddress;
    }

    @Generated
    public void setState(TaskExecutionStatus state) {
        this.state = state;
    }

    @Generated
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setExecutePath(String executePath) {
        this.executePath = executePath;
    }

    @Generated
    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    @Generated
    public void setProcessId(int processId) {
        this.processId = processId;
    }

    @Generated
    public void setAppIds(String appIds) {
        this.appIds = appIds;
    }

    @Generated
    public void setEvent(TaskEventType event) {
        this.event = event;
    }

    @Generated
    public void setVarPool(String varPool) {
        this.varPool = varPool;
    }

    @Generated
    public void setCacheTaskInstanceId(int cacheTaskInstanceId) {
        this.cacheTaskInstanceId = cacheTaskInstanceId;
    }

    @Generated
    public void setProcessInstanceId(int processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskEvent)) {
            return false;
        }
        TaskEvent other = (TaskEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTaskInstanceId() != other.getTaskInstanceId()) {
            return false;
        }
        if (this.getProcessId() != other.getProcessId()) {
            return false;
        }
        if (this.getCacheTaskInstanceId() != other.getCacheTaskInstanceId()) {
            return false;
        }
        if (this.getProcessInstanceId() != other.getProcessInstanceId()) {
            return false;
        }
        String this$workerAddress = this.getWorkerAddress();
        String other$workerAddress = other.getWorkerAddress();
        if (this$workerAddress == null ? other$workerAddress != null : !this$workerAddress.equals(other$workerAddress)) {
            return false;
        }
        TaskExecutionStatus this$state = this.getState();
        TaskExecutionStatus other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$executePath = this.getExecutePath();
        String other$executePath = other.getExecutePath();
        if (this$executePath == null ? other$executePath != null : !this$executePath.equals(other$executePath)) {
            return false;
        }
        String this$logPath = this.getLogPath();
        String other$logPath = other.getLogPath();
        if (this$logPath == null ? other$logPath != null : !this$logPath.equals(other$logPath)) {
            return false;
        }
        String this$appIds = this.getAppIds();
        String other$appIds = other.getAppIds();
        if (this$appIds == null ? other$appIds != null : !this$appIds.equals(other$appIds)) {
            return false;
        }
        TaskEventType this$event = this.getEvent();
        TaskEventType other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        String this$varPool = this.getVarPool();
        String other$varPool = other.getVarPool();
        return !(this$varPool == null ? other$varPool != null : !this$varPool.equals(other$varPool));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTaskInstanceId();
        result = result * 59 + this.getProcessId();
        result = result * 59 + this.getCacheTaskInstanceId();
        result = result * 59 + this.getProcessInstanceId();
        String $workerAddress = this.getWorkerAddress();
        result = result * 59 + ($workerAddress == null ? 43 : $workerAddress.hashCode());
        TaskExecutionStatus $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $executePath = this.getExecutePath();
        result = result * 59 + ($executePath == null ? 43 : $executePath.hashCode());
        String $logPath = this.getLogPath();
        result = result * 59 + ($logPath == null ? 43 : $logPath.hashCode());
        String $appIds = this.getAppIds();
        result = result * 59 + ($appIds == null ? 43 : $appIds.hashCode());
        TaskEventType $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        String $varPool = this.getVarPool();
        result = result * 59 + ($varPool == null ? 43 : $varPool.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TaskEvent(taskInstanceId=" + this.getTaskInstanceId() + ", workerAddress=" + this.getWorkerAddress() + ", state=" + this.getState() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", executePath=" + this.getExecutePath() + ", logPath=" + this.getLogPath() + ", processId=" + this.getProcessId() + ", appIds=" + this.getAppIds() + ", event=" + this.getEvent() + ", varPool=" + this.getVarPool() + ", cacheTaskInstanceId=" + this.getCacheTaskInstanceId() + ", processInstanceId=" + this.getProcessInstanceId() + ")";
    }

    @Generated
    public TaskEvent() {
    }

    @Generated
    public TaskEvent(int taskInstanceId, String workerAddress, TaskExecutionStatus state, Date startTime, Date endTime, String executePath, String logPath, int processId, String appIds, TaskEventType event, String varPool, int cacheTaskInstanceId, int processInstanceId) {
        this.taskInstanceId = taskInstanceId;
        this.workerAddress = workerAddress;
        this.state = state;
        this.startTime = startTime;
        this.endTime = endTime;
        this.executePath = executePath;
        this.logPath = logPath;
        this.processId = processId;
        this.appIds = appIds;
        this.event = event;
        this.varPool = varPool;
        this.cacheTaskInstanceId = cacheTaskInstanceId;
        this.processInstanceId = processInstanceId;
    }

    @Generated
    public static class TaskEventBuilder {
        @Generated
        private int taskInstanceId;
        @Generated
        private String workerAddress;
        @Generated
        private TaskExecutionStatus state;
        @Generated
        private Date startTime;
        @Generated
        private Date endTime;
        @Generated
        private String executePath;
        @Generated
        private String logPath;
        @Generated
        private int processId;
        @Generated
        private String appIds;
        @Generated
        private TaskEventType event;
        @Generated
        private String varPool;
        @Generated
        private int cacheTaskInstanceId;
        @Generated
        private int processInstanceId;

        @Generated
        TaskEventBuilder() {
        }

        @Generated
        public TaskEventBuilder taskInstanceId(int taskInstanceId) {
            this.taskInstanceId = taskInstanceId;
            return this;
        }

        @Generated
        public TaskEventBuilder workerAddress(String workerAddress) {
            this.workerAddress = workerAddress;
            return this;
        }

        @Generated
        public TaskEventBuilder state(TaskExecutionStatus state) {
            this.state = state;
            return this;
        }

        @Generated
        public TaskEventBuilder startTime(Date startTime) {
            this.startTime = startTime;
            return this;
        }

        @Generated
        public TaskEventBuilder endTime(Date endTime) {
            this.endTime = endTime;
            return this;
        }

        @Generated
        public TaskEventBuilder executePath(String executePath) {
            this.executePath = executePath;
            return this;
        }

        @Generated
        public TaskEventBuilder logPath(String logPath) {
            this.logPath = logPath;
            return this;
        }

        @Generated
        public TaskEventBuilder processId(int processId) {
            this.processId = processId;
            return this;
        }

        @Generated
        public TaskEventBuilder appIds(String appIds) {
            this.appIds = appIds;
            return this;
        }

        @Generated
        public TaskEventBuilder event(TaskEventType event) {
            this.event = event;
            return this;
        }

        @Generated
        public TaskEventBuilder varPool(String varPool) {
            this.varPool = varPool;
            return this;
        }

        @Generated
        public TaskEventBuilder cacheTaskInstanceId(int cacheTaskInstanceId) {
            this.cacheTaskInstanceId = cacheTaskInstanceId;
            return this;
        }

        @Generated
        public TaskEventBuilder processInstanceId(int processInstanceId) {
            this.processInstanceId = processInstanceId;
            return this;
        }

        @Generated
        public TaskEvent build() {
            return new TaskEvent(this.taskInstanceId, this.workerAddress, this.state, this.startTime, this.endTime, this.executePath, this.logPath, this.processId, this.appIds, this.event, this.varPool, this.cacheTaskInstanceId, this.processInstanceId);
        }

        @Generated
        public String toString() {
            return "TaskEvent.TaskEventBuilder(taskInstanceId=" + this.taskInstanceId + ", workerAddress=" + this.workerAddress + ", state=" + this.state + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", executePath=" + this.executePath + ", logPath=" + this.logPath + ", processId=" + this.processId + ", appIds=" + this.appIds + ", event=" + this.event + ", varPool=" + this.varPool + ", cacheTaskInstanceId=" + this.cacheTaskInstanceId + ", processInstanceId=" + this.processInstanceId + ")";
        }
    }
}

