/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.apache.dolphinscheduler.registry.api.ConnectionState;
import org.apache.dolphinscheduler.server.master.registry.MasterConnectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterConnectionStateListener
implements ConnectionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterConnectionStateListener.class);
    private final MasterConnectStrategy masterConnectStrategy;

    public MasterConnectionStateListener(@NonNull MasterConnectStrategy masterConnectStrategy) {
        if (masterConnectStrategy == null) {
            throw new NullPointerException("masterConnectStrategy is marked non-null but is null");
        }
        this.masterConnectStrategy = masterConnectStrategy;
    }

    public void onUpdate(ConnectionState state) {
        log.info("Master received a {} event from registry, the current server state is {}", (Object)state, (Object)ServerLifeCycleManager.getServerStatus());
        switch (state) {
            case CONNECTED: {
                break;
            }
            case SUSPENDED: {
                break;
            }
            case RECONNECTED: {
                this.masterConnectStrategy.reconnect();
                break;
            }
            case DISCONNECTED: {
                this.masterConnectStrategy.disconnect();
                break;
            }
        }
    }
}

