/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.enums.ServerStatus;
import org.apache.dolphinscheduler.common.model.MasterHeartBeat;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.meter.metrics.MetricsProvider;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.apache.dolphinscheduler.registry.api.SubscribeListener;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.registry.MasterConnectStrategy;
import org.apache.dolphinscheduler.server.master.registry.MasterConnectionStateListener;
import org.apache.dolphinscheduler.server.master.registry.MasterRegistryDataListener;
import org.apache.dolphinscheduler.server.master.service.FailoverService;
import org.apache.dolphinscheduler.server.master.task.MasterHeartBeatTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MasterRegistryClient
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterRegistryClient.class);
    @Autowired
    private FailoverService failoverService;
    @Autowired
    private RegistryClient registryClient;
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private MetricsProvider metricsProvider;
    @Autowired
    private MasterConnectStrategy masterConnectStrategy;
    private MasterHeartBeatTask masterHeartBeatTask;

    public void start() {
        try {
            this.masterHeartBeatTask = new MasterHeartBeatTask(this.masterConfig, this.metricsProvider, this.registryClient);
            this.registry();
            this.registryClient.addConnectionStateListener((ConnectionListener)new MasterConnectionStateListener(this.masterConnectStrategy));
            this.registryClient.subscribe(RegistryNodeType.ALL_SERVERS.getRegistryPath(), (SubscribeListener)new MasterRegistryDataListener());
        }
        catch (Exception e) {
            throw new RegistryException("Master registry client start up error", (Throwable)e);
        }
    }

    public void setRegistryStoppable(IStoppable stoppable) {
        this.registryClient.setStoppable(stoppable);
    }

    @Override
    public void close() {
        this.deregister();
    }

    public void removeMasterNodePath(String path, RegistryNodeType nodeType, boolean failover) {
        log.info("{} node deleted : {}", (Object)nodeType, (Object)path);
        if (StringUtils.isEmpty((CharSequence)path)) {
            log.error("server down error: empty path: {}, nodeType:{}", (Object)path, (Object)nodeType);
            return;
        }
        String serverHost = this.registryClient.getHostByEventDataPath(path);
        if (StringUtils.isEmpty((CharSequence)serverHost)) {
            log.error("server down error: unknown path: {}, nodeType:{}", (Object)path, (Object)nodeType);
            return;
        }
        try {
            if (!this.registryClient.exists(path)) {
                log.info("path: {} not exists", (Object)path);
            }
            if (failover) {
                this.failoverService.failoverServerWhenDown(serverHost, nodeType);
            }
        }
        catch (Exception e) {
            log.error("{} server failover failed, host:{}", new Object[]{nodeType, serverHost, e});
        }
    }

    public void removeWorkerNodePath(String path, RegistryNodeType nodeType, boolean failover) {
        log.info("{} node deleted : {}", (Object)nodeType, (Object)path);
        try {
            String serverHost = null;
            if (!StringUtils.isEmpty((CharSequence)path)) {
                serverHost = this.registryClient.getHostByEventDataPath(path);
                if (StringUtils.isEmpty((CharSequence)serverHost)) {
                    log.error("server down error: unknown path: {}", (Object)path);
                    return;
                }
                if (!this.registryClient.exists(path)) {
                    log.info("path: {} not exists", (Object)path);
                }
            }
            if (failover) {
                this.failoverService.failoverServerWhenDown(serverHost, nodeType);
            }
        }
        catch (Exception e) {
            log.error("{} server failover failed", (Object)nodeType, (Object)e);
        }
    }

    void registry() {
        log.info("Master node : {} registering to registry center", (Object)this.masterConfig.getMasterAddress());
        String masterRegistryPath = this.masterConfig.getMasterRegistryPath();
        MasterHeartBeat heartBeat = this.masterHeartBeatTask.getHeartBeat();
        while (ServerStatus.BUSY.equals((Object)heartBeat.getServerStatus())) {
            log.warn("Master node is BUSY: {}", (Object)heartBeat);
            heartBeat = this.masterHeartBeatTask.getHeartBeat();
            ThreadUtils.sleep((long)1000L);
        }
        this.registryClient.remove(masterRegistryPath);
        this.registryClient.persistEphemeral(masterRegistryPath, JSONUtils.toJsonString((Object)this.masterHeartBeatTask.getHeartBeat()));
        while (!this.registryClient.checkNodeExists(NetUtils.getHost(), RegistryNodeType.MASTER)) {
            log.warn("The current master server node:{} cannot find in registry", (Object)NetUtils.getHost());
            ThreadUtils.sleep((long)1000L);
        }
        ThreadUtils.sleep((long)1000L);
        this.masterHeartBeatTask.start();
        log.info("Master node : {} registered to registry center successfully", (Object)this.masterConfig.getMasterAddress());
    }

    public void deregister() {
        try {
            this.registryClient.remove(this.masterConfig.getMasterRegistryPath());
            log.info("Master node : {} unRegistry to register center.", (Object)this.masterConfig.getMasterAddress());
            if (this.masterHeartBeatTask != null) {
                this.masterHeartBeatTask.shutdown();
            }
            this.registryClient.close();
        }
        catch (Exception e) {
            log.error("MasterServer remove registry path exception ", (Throwable)e);
        }
    }
}

