/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.dolphinscheduler.registry.api.Event;
import org.apache.dolphinscheduler.registry.api.SubscribeListener;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.apache.dolphinscheduler.server.master.registry.MasterRegistryClient;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterRegistryDataListener
implements SubscribeListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterRegistryDataListener.class);
    private final MasterRegistryClient masterRegistryClient = (MasterRegistryClient)SpringApplicationContext.getBean(MasterRegistryClient.class);

    public void notify(Event event) {
        String path = event.path();
        if (Strings.isNullOrEmpty((String)path)) {
            return;
        }
        if (path.startsWith(RegistryNodeType.MASTER.getRegistryPath() + "/")) {
            this.handleMasterEvent(event);
        } else if (path.startsWith(RegistryNodeType.WORKER.getRegistryPath() + "/")) {
            this.handleWorkerEvent(event);
        }
    }

    private void handleMasterEvent(Event event) {
        String path = event.path();
        switch (event.type()) {
            case ADD: {
                log.info("master node added : {}", (Object)path);
                break;
            }
            case REMOVE: {
                this.masterRegistryClient.removeMasterNodePath(path, RegistryNodeType.MASTER, true);
                break;
            }
        }
    }

    private void handleWorkerEvent(Event event) {
        String path = event.path();
        switch (event.type()) {
            case ADD: {
                log.info("worker node added : {}", (Object)path);
                break;
            }
            case REMOVE: {
                log.info("worker node deleted : {}", (Object)path);
                this.masterRegistryClient.removeWorkerNodePath(path, RegistryNodeType.WORKER, true);
                break;
            }
        }
    }
}

