/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.ServerStatus;
import org.apache.dolphinscheduler.common.model.MasterHeartBeat;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.registry.MasterInfoChangeListener;
import org.apache.dolphinscheduler.server.master.registry.ServerNodeManager;
import org.apache.dolphinscheduler.service.queue.MasterPriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MasterSlotManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterSlotManager.class);
    @Autowired
    protected ServerNodeManager serverNodeManager;
    @Autowired
    protected MasterConfig masterConfig;
    private volatile int currentSlot = 0;
    private volatile int totalSlot = 0;

    public void start() {
        this.serverNodeManager.addMasterInfoChangeListener(new SlotChangeListener());
    }

    public int getSlot() {
        return this.currentSlot;
    }

    public int getMasterSize() {
        return this.totalSlot;
    }

    public class SlotChangeListener
    implements MasterInfoChangeListener {
        private final Lock slotLock = new ReentrantLock();
        private final MasterPriorityQueue masterPriorityQueue = new MasterPriorityQueue();

        @Override
        public void notify(Map<String, MasterHeartBeat> masterNodeInfo) {
            List<Server> serverList = masterNodeInfo.values().stream().filter(heartBeat -> !heartBeat.getServerStatus().equals((Object)ServerStatus.BUSY)).map(this::convertHeartBeatToServer).collect(Collectors.toList());
            this.syncMasterNodes(serverList);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void syncMasterNodes(List<Server> masterNodes) {
            this.slotLock.lock();
            try {
                this.masterPriorityQueue.clear();
                this.masterPriorityQueue.putAll(masterNodes);
                int tempCurrentSlot = this.masterPriorityQueue.getIndex(MasterSlotManager.this.masterConfig.getMasterAddress());
                int tempTotalSlot = masterNodes.size();
                if (tempCurrentSlot < 0) {
                    MasterSlotManager.this.totalSlot = 0;
                    MasterSlotManager.this.currentSlot = 0;
                    log.warn("Current master is not in active master list");
                } else if (tempCurrentSlot != MasterSlotManager.this.currentSlot || tempTotalSlot != MasterSlotManager.this.totalSlot) {
                    MasterSlotManager.this.totalSlot = tempTotalSlot;
                    MasterSlotManager.this.currentSlot = tempCurrentSlot;
                    log.info("Update master nodes, total master size: {}, current slot: {}", (Object)MasterSlotManager.this.totalSlot, (Object)MasterSlotManager.this.currentSlot);
                }
            }
            finally {
                this.slotLock.unlock();
            }
        }

        private Server convertHeartBeatToServer(MasterHeartBeat masterHeartBeat) {
            Server server = new Server();
            server.setCreateTime(new Date(masterHeartBeat.getStartupTime()));
            server.setLastHeartbeatTime(new Date(masterHeartBeat.getReportTime()));
            server.setId(masterHeartBeat.getProcessId());
            server.setHost(masterHeartBeat.getHost());
            server.setPort(masterHeartBeat.getPort());
            return server;
        }
    }
}

