/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.rpc;

import lombok.Generated;
import org.apache.dolphinscheduler.extract.master.transportor.LogicTaskDispatchRequest;
import org.apache.dolphinscheduler.extract.master.transportor.LogicTaskDispatchResponse;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.master.rpc.ITaskInstanceOperationFunction;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecutionContextHolder;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecutor;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecutorFactoryBuilder;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecutorThreadPoolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogicITaskInstanceDispatchOperationFunction
implements ITaskInstanceOperationFunction<LogicTaskDispatchRequest, LogicTaskDispatchResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogicITaskInstanceDispatchOperationFunction.class);
    @Autowired
    private MasterTaskExecutorFactoryBuilder masterTaskExecutorFactoryBuilder;
    @Autowired
    private MasterTaskExecutorThreadPoolManager masterTaskExecutorThreadPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogicTaskDispatchResponse operate(LogicTaskDispatchRequest taskDispatchRequest) {
        log.info("Received dispatchLogicTask request: {}", (Object)taskDispatchRequest);
        TaskExecutionContext taskExecutionContext = taskDispatchRequest.getTaskExecutionContext();
        try {
            int taskInstanceId = taskExecutionContext.getTaskInstanceId();
            int workflowInstanceId = taskExecutionContext.getProcessInstanceId();
            String taskInstanceName = taskExecutionContext.getTaskName();
            taskExecutionContext.setLogPath(LogUtils.getTaskInstanceLogFullPath((TaskExecutionContext)taskExecutionContext));
            LogUtils.setWorkflowAndTaskInstanceIDMDC((Integer)workflowInstanceId, (Integer)taskInstanceId);
            LogUtils.setTaskInstanceLogFullPathMDC((String)taskExecutionContext.getLogPath());
            MasterTaskExecutionContextHolder.putTaskExecutionContext(taskExecutionContext);
            MasterTaskExecutor masterTaskExecutor = this.masterTaskExecutorFactoryBuilder.createMasterTaskExecutorFactory(taskExecutionContext.getTaskType()).createMasterTaskExecutor(taskExecutionContext);
            if (this.masterTaskExecutorThreadPool.submitMasterTaskExecutor(masterTaskExecutor)) {
                log.info("Submit LogicTask: {} to MasterTaskExecutorThreadPool success", (Object)taskInstanceName);
                LogicTaskDispatchResponse logicTaskDispatchResponse = LogicTaskDispatchResponse.success((Integer)taskInstanceId);
                return logicTaskDispatchResponse;
            }
            log.error("Submit LogicTask: {} to MasterTaskExecutorThreadPool failed", (Object)taskInstanceName);
            LogicTaskDispatchResponse logicTaskDispatchResponse = LogicTaskDispatchResponse.failed((Integer)taskInstanceId, (String)"MasterTaskExecutorThreadPool is full");
            return logicTaskDispatchResponse;
        }
        finally {
            LogUtils.removeWorkflowAndTaskInstanceIdMDC();
            LogUtils.removeTaskInstanceLogFullPathMDC();
        }
    }
}

