/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.rpc;

import lombok.Generated;
import org.apache.dolphinscheduler.extract.master.transportor.LogicTaskKillRequest;
import org.apache.dolphinscheduler.extract.master.transportor.LogicTaskKillResponse;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.master.exception.MasterTaskExecuteException;
import org.apache.dolphinscheduler.server.master.rpc.ITaskInstanceOperationFunction;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecutionContextHolder;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecutor;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecutorHolder;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecutorThreadPoolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogicITaskInstanceKillOperationFunction
implements ITaskInstanceOperationFunction<LogicTaskKillRequest, LogicTaskKillResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogicITaskInstanceKillOperationFunction.class);
    @Autowired
    private MasterTaskExecutorThreadPoolManager masterTaskExecutorThreadPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public LogicTaskKillResponse operate(LogicTaskKillRequest taskKillRequest) {
        int taskInstanceId = taskKillRequest.getTaskInstanceId();
        try {
            LogicTaskKillResponse logicTaskKillResponse;
            LogUtils.setTaskInstanceIdMDC((Integer)taskKillRequest.getTaskInstanceId());
            log.info("Received killLogicTask request: {}", (Object)taskKillRequest);
            MasterTaskExecutor masterTaskExecutor = MasterTaskExecutorHolder.getMasterTaskExecutor(taskInstanceId);
            if (masterTaskExecutor == null) {
                log.error("Cannot find the MasterTaskExecuteRunnable, this task may already been killed");
                LogicTaskKillResponse logicTaskKillResponse2 = LogicTaskKillResponse.fail((String)"Cannot find the MasterTaskExecuteRunnable");
                return logicTaskKillResponse2;
            }
            try {
                masterTaskExecutor.cancelTask();
                this.masterTaskExecutorThreadPool.removeMasterTaskExecutor(masterTaskExecutor);
                logicTaskKillResponse = LogicTaskKillResponse.success();
            }
            catch (MasterTaskExecuteException e) {
                log.error("Cancel MasterTaskExecuteRunnable failed ", (Throwable)e);
                LogicTaskKillResponse logicTaskKillResponse3 = LogicTaskKillResponse.fail((String)("Cancel MasterTaskExecuteRunnable failed: " + e.getMessage()));
                MasterTaskExecutionContextHolder.removeTaskExecutionContext(taskInstanceId);
                MasterTaskExecutorHolder.removeMasterTaskExecutor(taskInstanceId);
                LogUtils.removeTaskInstanceIdMDC();
                return logicTaskKillResponse3;
                {
                    catch (Throwable throwable) {
                        MasterTaskExecutionContextHolder.removeTaskExecutionContext(taskInstanceId);
                        MasterTaskExecutorHolder.removeMasterTaskExecutor(taskInstanceId);
                        throw throwable;
                    }
                }
            }
            MasterTaskExecutionContextHolder.removeTaskExecutionContext(taskInstanceId);
            MasterTaskExecutorHolder.removeMasterTaskExecutor(taskInstanceId);
            return logicTaskKillResponse;
        }
        finally {
            LogUtils.removeTaskInstanceIdMDC();
        }
    }
}

