/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.rpc;

import lombok.Generated;
import org.apache.dolphinscheduler.extract.master.transportor.LogicTaskPauseRequest;
import org.apache.dolphinscheduler.extract.master.transportor.LogicTaskPauseResponse;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.master.exception.MasterTaskExecuteException;
import org.apache.dolphinscheduler.server.master.rpc.ITaskInstanceOperationFunction;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecutor;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecutorHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LogicITaskInstancePauseOperationFunction
implements ITaskInstanceOperationFunction<LogicTaskPauseRequest, LogicTaskPauseResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogicITaskInstancePauseOperationFunction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogicTaskPauseResponse operate(LogicTaskPauseRequest taskPauseRequest) {
        try {
            LogUtils.setTaskInstanceIdMDC((Integer)taskPauseRequest.getTaskInstanceId());
            MasterTaskExecutor masterTaskExecutor = MasterTaskExecutorHolder.getMasterTaskExecutor(taskPauseRequest.getTaskInstanceId());
            if (masterTaskExecutor == null) {
                log.info("Cannot find the MasterTaskExecuteRunnable");
                LogicTaskPauseResponse logicTaskPauseResponse = LogicTaskPauseResponse.fail((String)"Cannot find the MasterTaskExecuteRunnable");
                return logicTaskPauseResponse;
            }
            TaskExecutionContext taskExecutionContext = masterTaskExecutor.getTaskExecutionContext();
            LogUtils.setWorkflowAndTaskInstanceIDMDC((Integer)taskExecutionContext.getProcessInstanceId(), (Integer)taskExecutionContext.getTaskInstanceId());
            masterTaskExecutor.pauseTask();
            LogicTaskPauseResponse logicTaskPauseResponse = LogicTaskPauseResponse.success();
            return logicTaskPauseResponse;
        }
        catch (MasterTaskExecuteException e) {
            log.error("Pause MasterTaskExecuteRunnable failed", (Throwable)e);
            LogicTaskPauseResponse logicTaskPauseResponse = LogicTaskPauseResponse.fail((String)("Pause MasterTaskExecuteRunnable failed: " + e.getMessage()));
            return logicTaskPauseResponse;
        }
        finally {
            LogUtils.removeTaskInstanceIdMDC();
            LogUtils.removeWorkflowAndTaskInstanceIdMDC();
        }
    }
}

