/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.rpc;

import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionDao;
import org.apache.dolphinscheduler.extract.master.IStreamingTaskOperator;
import org.apache.dolphinscheduler.extract.master.transportor.StreamingTaskTriggerRequest;
import org.apache.dolphinscheduler.extract.master.transportor.StreamingTaskTriggerResponse;
import org.apache.dolphinscheduler.server.master.runner.StreamTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.StreamTaskExecuteThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StreamingTaskOperatorImpl
implements IStreamingTaskOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamingTaskOperatorImpl.class);
    @Autowired
    private StreamTaskExecuteThreadPool streamTaskExecuteThreadPool;
    @Autowired
    private TaskDefinitionDao taskDefinitionDao;

    public StreamingTaskTriggerResponse triggerStreamingTask(StreamingTaskTriggerRequest streamingTaskTriggerRequest) {
        log.info("Receive triggerStreamingTask request: {}", (Object)streamingTaskTriggerRequest);
        TaskDefinition taskDefinition = this.taskDefinitionDao.findTaskDefinition(streamingTaskTriggerRequest.getTaskDefinitionCode(), streamingTaskTriggerRequest.getTaskDefinitionVersion());
        if (taskDefinition == null) {
            log.error("Cannot find the Streaming TaskDefinition: {}", (Object)streamingTaskTriggerRequest);
            return StreamingTaskTriggerResponse.fail((String)"Cannot find the Streaming TaskDefinition");
        }
        this.streamTaskExecuteThreadPool.execute(new StreamTaskExecuteRunnable(taskDefinition, streamingTaskTriggerRequest));
        return StreamingTaskTriggerResponse.success();
    }
}

