/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.rpc;

import lombok.Generated;
import org.apache.dolphinscheduler.extract.master.transportor.TaskInstanceWakeupRequest;
import org.apache.dolphinscheduler.extract.master.transportor.TaskInstanceWakeupResponse;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.rpc.ITaskInstanceOperationFunction;
import org.apache.dolphinscheduler.server.master.runner.DefaultTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskInstanceWakeupOperationFunction
implements ITaskInstanceOperationFunction<TaskInstanceWakeupRequest, TaskInstanceWakeupResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskInstanceWakeupOperationFunction.class);
    @Autowired
    private ProcessInstanceExecCacheManager processInstanceExecCacheManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskInstanceWakeupResponse operate(TaskInstanceWakeupRequest taskInstanceWakeupRequest) {
        try {
            log.info("Received TaskInstanceWakeupRequest request{}", (Object)taskInstanceWakeupRequest);
            int workflowInstanceId = taskInstanceWakeupRequest.getProcessInstanceId();
            int taskInstanceId = taskInstanceWakeupRequest.getTaskInstanceId();
            LogUtils.setWorkflowAndTaskInstanceIDMDC((Integer)workflowInstanceId, (Integer)taskInstanceId);
            WorkflowExecuteRunnable workflowExecuteRunnable = this.processInstanceExecCacheManager.getByProcessInstanceId(workflowInstanceId);
            if (workflowExecuteRunnable == null) {
                log.warn("cannot find WorkflowExecuteRunnable: {}, no need to Wakeup task", (Object)workflowInstanceId);
                TaskInstanceWakeupResponse taskInstanceWakeupResponse = TaskInstanceWakeupResponse.failed((String)("cannot find WorkflowExecuteRunnable: " + workflowInstanceId));
                return taskInstanceWakeupResponse;
            }
            DefaultTaskExecuteRunnable defaultTaskExecuteRunnable = workflowExecuteRunnable.getTaskExecuteRunnableById(taskInstanceId).orElse(null);
            if (defaultTaskExecuteRunnable == null) {
                log.warn("Cannot find DefaultTaskExecuteRunnable: {}, cannot Wakeup task", (Object)taskInstanceId);
                TaskInstanceWakeupResponse taskInstanceWakeupResponse = TaskInstanceWakeupResponse.failed((String)("Cannot find DefaultTaskExecuteRunnable: " + taskInstanceId));
                return taskInstanceWakeupResponse;
            }
            defaultTaskExecuteRunnable.dispatch();
            log.info("Success Wakeup TaskInstance: {}", (Object)taskInstanceId);
            TaskInstanceWakeupResponse taskInstanceWakeupResponse = TaskInstanceWakeupResponse.success();
            return taskInstanceWakeupResponse;
        }
        finally {
            LogUtils.removeWorkflowAndTaskInstanceIdMDC();
        }
    }
}

