/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.rpc;

import java.util.Optional;
import lombok.Generated;
import org.apache.dolphinscheduler.extract.master.IWorkflowInstanceService;
import org.apache.dolphinscheduler.extract.master.dto.WorkflowExecuteDto;
import org.apache.dolphinscheduler.extract.master.transportor.TaskInstanceWakeupRequest;
import org.apache.dolphinscheduler.extract.master.transportor.TaskInstanceWakeupResponse;
import org.apache.dolphinscheduler.server.master.metrics.ProcessInstanceMetrics;
import org.apache.dolphinscheduler.server.master.rpc.TaskInstanceWakeupOperationFunction;
import org.apache.dolphinscheduler.server.master.service.ExecutingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowInstanceServiceImpl
implements IWorkflowInstanceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowInstanceServiceImpl.class);
    @Autowired
    private ExecutingService executingService;
    @Autowired
    private TaskInstanceWakeupOperationFunction taskInstanceWakeupOperationFunction;

    public void clearWorkflowMetrics(Long workflowDefinitionCode) {
        log.info("Receive clearWorkflowMetrics request: {}", (Object)workflowDefinitionCode);
        ProcessInstanceMetrics.cleanUpProcessInstanceCountMetricsByDefinitionCode(workflowDefinitionCode);
    }

    public WorkflowExecuteDto getWorkflowExecutingData(Integer workflowInstanceId) {
        log.info("Receive getWorkflowExecutingData request: {}", (Object)workflowInstanceId);
        Optional<WorkflowExecuteDto> workflowExecuteDtoOptional = this.executingService.queryWorkflowExecutingData(workflowInstanceId);
        return workflowExecuteDtoOptional.orElse(null);
    }

    public TaskInstanceWakeupResponse wakeupTaskInstance(TaskInstanceWakeupRequest taskWakeupRequest) {
        return this.taskInstanceWakeupOperationFunction.operate(taskWakeupRequest);
    }
}

