/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Optional;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.TaskEventType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.extract.base.utils.Host;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.dispatch.exceptions.WorkerGroupNotFoundException;
import org.apache.dolphinscheduler.server.master.exception.TaskDispatchException;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEvent;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEventService;
import org.apache.dolphinscheduler.server.master.runner.TaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.dispatcher.TaskDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTaskDispatcher
implements TaskDispatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseTaskDispatcher.class);
    protected final TaskEventService taskEventService;
    protected final MasterConfig masterConfig;

    protected BaseTaskDispatcher(TaskEventService taskEventService, MasterConfig masterConfig) {
        this.taskEventService = (TaskEventService)Preconditions.checkNotNull((Object)taskEventService);
        this.masterConfig = (MasterConfig)Preconditions.checkNotNull((Object)masterConfig);
    }

    @Override
    public void dispatchTask(TaskExecuteRunnable taskExecuteRunnable) throws TaskDispatchException {
        Host taskInstanceDispatchHost;
        try {
            taskInstanceDispatchHost = this.getTaskInstanceDispatchHost(taskExecuteRunnable).orElseThrow(() -> new TaskDispatchException("Cannot find the host to execute task."));
        }
        catch (WorkerGroupNotFoundException workerGroupNotFoundException) {
            log.error("Dispatch task: {} failed, worker group not found.", (Object)taskExecuteRunnable.getTaskExecutionContext().getTaskName(), (Object)workerGroupNotFoundException);
            this.addDispatchFailedEvent(taskExecuteRunnable);
            return;
        }
        taskExecuteRunnable.getTaskExecutionContext().setHost(taskInstanceDispatchHost.getAddress());
        this.doDispatch(taskExecuteRunnable);
        taskExecuteRunnable.getTaskInstance().setHost(taskInstanceDispatchHost.getAddress());
        log.info("Success dispatch task {} to {}.", (Object)taskExecuteRunnable.getTaskExecutionContext().getTaskName(), (Object)taskInstanceDispatchHost.getAddress());
        this.addDispatchEvent(taskExecuteRunnable);
    }

    protected abstract void doDispatch(TaskExecuteRunnable var1) throws TaskDispatchException;

    protected abstract Optional<Host> getTaskInstanceDispatchHost(TaskExecuteRunnable var1) throws TaskDispatchException, WorkerGroupNotFoundException;

    protected void addDispatchEvent(TaskExecuteRunnable taskExecuteRunnable) {
        TaskExecutionContext taskExecutionContext = taskExecuteRunnable.getTaskExecutionContext();
        TaskEvent taskEvent = TaskEvent.newDispatchEvent(taskExecutionContext.getProcessInstanceId(), taskExecutionContext.getTaskInstanceId(), taskExecutionContext.getHost());
        this.taskEventService.addEvent(taskEvent);
    }

    private void addDispatchFailedEvent(TaskExecuteRunnable taskExecuteRunnable) {
        TaskExecutionContext taskExecutionContext = taskExecuteRunnable.getTaskExecutionContext();
        TaskEvent taskEvent = TaskEvent.builder().processInstanceId(taskExecutionContext.getProcessInstanceId()).taskInstanceId(taskExecutionContext.getTaskInstanceId()).state(TaskExecutionStatus.FAILURE).logPath(taskExecutionContext.getLogPath()).executePath(taskExecutionContext.getExecutePath()).appIds(taskExecutionContext.getAppIds()).processId(taskExecutionContext.getProcessId()).varPool(taskExecutionContext.getVarPool()).startTime(DateUtils.timeStampToDate((long)taskExecutionContext.getStartTime())).endTime(new Date()).event(TaskEventType.RESULT).build();
        this.taskEventService.addEvent(taskEvent);
    }
}

