/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.master.runner.BaseTaskExecuteRunnable;

public abstract class PriorityDelayTaskExecuteRunnable
extends BaseTaskExecuteRunnable
implements Delayed {
    public PriorityDelayTaskExecuteRunnable(ProcessInstance workflowInstance, TaskInstance taskInstance, TaskExecutionContext taskExecutionContext) {
        super(workflowInstance, taskInstance, taskExecutionContext);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(DateUtils.getRemainTime((Long)this.taskExecutionContext.getFirstSubmitTime(), (long)((long)this.taskExecutionContext.getDelayTime() * 60L)), TimeUnit.SECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        if (o == null) {
            return 1;
        }
        int delayTimeCompareResult = Long.compare(this.getDelay(TimeUnit.MILLISECONDS), o.getDelay(TimeUnit.MILLISECONDS));
        if (delayTimeCompareResult != 0) {
            return delayTimeCompareResult;
        }
        PriorityDelayTaskExecuteRunnable other = (PriorityDelayTaskExecuteRunnable)o;
        int dispatchFailTimesCompareResult = this.taskExecutionContext.getDispatchFailTimes() - other.getTaskExecutionContext().getDispatchFailTimes();
        if (dispatchFailTimesCompareResult != 0) {
            return dispatchFailTimesCompareResult;
        }
        int workflowInstancePriorityCompareResult = this.workflowInstance.getProcessInstancePriority().getCode() - other.getWorkflowInstance().getProcessInstancePriority().getCode();
        if (workflowInstancePriorityCompareResult != 0) {
            return workflowInstancePriorityCompareResult;
        }
        long workflowInstanceIdCompareResult = this.workflowInstance.getId().compareTo(other.getWorkflowInstance().getId());
        if (workflowInstanceIdCompareResult != 0L) {
            return workflowInstancePriorityCompareResult;
        }
        int taskInstancePriorityCompareResult = this.taskInstance.getTaskInstancePriority().getCode() - other.getTaskInstance().getTaskInstancePriority().getCode();
        if (taskInstancePriorityCompareResult != 0) {
            return taskInstancePriorityCompareResult;
        }
        int taskGroupPriorityCompareResult = this.taskInstance.getTaskGroupPriority() - other.getTaskInstance().getTaskGroupPriority();
        if (taskGroupPriorityCompareResult != 0) {
            return -taskGroupPriorityCompareResult;
        }
        return this.taskInstance.getId().compareTo(other.getTaskInstance().getId());
    }
}

