/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import com.zaxxer.hikari.HikariDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.DqComparisonType;
import org.apache.dolphinscheduler.dao.entity.DqRule;
import org.apache.dolphinscheduler.dao.entity.DqRuleExecuteSql;
import org.apache.dolphinscheduler.dao.entity.DqRuleInputEntry;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.DataQualityTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.K8sTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskPluginManager;
import org.apache.dolphinscheduler.plugin.task.api.enums.dp.ConnectorType;
import org.apache.dolphinscheduler.plugin.task.api.enums.dp.ExecuteSqlType;
import org.apache.dolphinscheduler.plugin.task.api.model.JdbcInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.K8sTaskParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.ParametersNode;
import org.apache.dolphinscheduler.plugin.task.api.parameters.dataquality.DataQualityParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.AbstractResourceParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.DataSourceParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.ResourceParametersHelper;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.UdfFuncParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.JdbcUrlParser;
import org.apache.dolphinscheduler.plugin.task.api.utils.MapUtils;
import org.apache.dolphinscheduler.plugin.task.spark.SparkParameters;
import org.apache.dolphinscheduler.server.master.builder.TaskExecutionContextBuilder;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.exception.TaskExecutionContextCreateException;
import org.apache.dolphinscheduler.service.expand.CuringParamsService;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.spi.datasource.DefaultConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskExecutionContextFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecutionContextFactory.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private TaskPluginManager taskPluginManager;
    @Autowired
    private CuringParamsService curingParamsService;
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private HikariDataSource hikariDataSource;

    public TaskExecutionContext createTaskExecutionContext(TaskInstance taskInstance) throws TaskExecutionContextCreateException {
        ProcessInstance workflowInstance = taskInstance.getProcessInstance();
        ResourceParametersHelper resources = Optional.ofNullable(this.taskPluginManager.getTaskChannel(taskInstance.getTaskType())).map(taskChannel -> taskChannel.getResources(taskInstance.getTaskParams())).orElse(null);
        this.setTaskResourceInfo(resources);
        Map businessParamsMap = this.curingParamsService.preBuildBusinessParams(workflowInstance);
        AbstractParameters baseParam = this.taskPluginManager.getParameters(ParametersNode.builder().taskType(taskInstance.getTaskType()).taskParams(taskInstance.getTaskParams()).build());
        Map propertyMap = this.curingParamsService.paramParsingPreparation(taskInstance, baseParam, workflowInstance);
        TaskExecutionContext taskExecutionContext = TaskExecutionContextBuilder.get().buildWorkflowInstanceHost(this.masterConfig.getMasterAddress()).buildTaskInstanceRelatedInfo(taskInstance).buildTaskDefinitionRelatedInfo(taskInstance.getTaskDefine()).buildProcessInstanceRelatedInfo(taskInstance.getProcessInstance()).buildProcessDefinitionRelatedInfo(taskInstance.getProcessDefine()).buildResourceParametersInfo(resources).buildBusinessParamsMap(businessParamsMap).buildParamInfo(propertyMap).create();
        this.setDataQualityTaskExecutionContext(taskExecutionContext, taskInstance, workflowInstance.getTenantCode());
        this.setK8sTaskRelatedInfo(taskExecutionContext, taskInstance);
        return taskExecutionContext;
    }

    public void setDataQualityTaskExecutionContext(TaskExecutionContext taskExecutionContext, TaskInstance taskInstance, String tenantCode) {
        DataQualityTaskExecutionContext dataQualityTaskExecutionContext = null;
        if ("DATA_QUALITY".equalsIgnoreCase(taskInstance.getTaskType())) {
            dataQualityTaskExecutionContext = new DataQualityTaskExecutionContext();
            this.setDataQualityTaskRelation(dataQualityTaskExecutionContext, taskInstance, tenantCode);
        }
        taskExecutionContext.setDataQualityTaskExecutionContext(dataQualityTaskExecutionContext);
    }

    public void setK8sTaskRelatedInfo(TaskExecutionContext taskExecutionContext, TaskInstance taskInstance) {
        K8sTaskExecutionContext k8sTaskExecutionContext = this.setK8sTaskRelation(taskInstance);
        taskExecutionContext.setK8sTaskExecutionContext(k8sTaskExecutionContext);
    }

    private void setTaskResourceInfo(ResourceParametersHelper resourceParametersHelper) {
        if (Objects.isNull(resourceParametersHelper)) {
            return;
        }
        resourceParametersHelper.getResourceMap().forEach((type, map) -> {
            switch (type) {
                case DATASOURCE: {
                    this.setTaskDataSourceResourceInfo((Map<Integer, AbstractResourceParameters>)map);
                    break;
                }
                case UDF: {
                    this.setTaskUdfFuncResourceInfo((Map<Integer, AbstractResourceParameters>)map);
                    break;
                }
            }
        });
    }

    private void setTaskDataSourceResourceInfo(Map<Integer, AbstractResourceParameters> map) {
        if (MapUtils.isEmpty(map)) {
            return;
        }
        map.forEach((code, parameters) -> {
            DataSource datasource = this.processService.findDataSourceById(code.intValue());
            if (Objects.isNull(datasource)) {
                return;
            }
            DataSourceParameters dataSourceParameters = new DataSourceParameters();
            dataSourceParameters.setType(datasource.getType());
            dataSourceParameters.setConnectionParams(datasource.getConnectionParams());
            map.put((Integer)code, (AbstractResourceParameters)dataSourceParameters);
        });
    }

    private void setTaskUdfFuncResourceInfo(Map<Integer, AbstractResourceParameters> map) {
        if (MapUtils.isEmpty(map)) {
            return;
        }
        List udfFuncList = this.processService.queryUdfFunListByIds(map.keySet().toArray(new Integer[map.size()]));
        udfFuncList.forEach(udfFunc -> {
            UdfFuncParameters udfFuncParameters = (UdfFuncParameters)JSONUtils.parseObject((String)JSONUtils.toJsonString((Object)udfFunc), UdfFuncParameters.class);
            map.put(udfFunc.getId(), (AbstractResourceParameters)udfFuncParameters);
        });
    }

    private void setDataQualityTaskRelation(DataQualityTaskExecutionContext dataQualityTaskExecutionContext, TaskInstance taskInstance, String tenantCode) {
        DataQualityParameters dataQualityParameters = (DataQualityParameters)JSONUtils.parseObject((String)taskInstance.getTaskParams(), DataQualityParameters.class);
        if (dataQualityParameters == null) {
            return;
        }
        Map config = dataQualityParameters.getRuleInputParameter();
        int ruleId = dataQualityParameters.getRuleId();
        DqRule dqRule = this.processService.getDqRule(ruleId);
        if (dqRule == null) {
            log.error("Can not get dataQuality rule by id {}", (Object)ruleId);
            return;
        }
        dataQualityTaskExecutionContext.setRuleId(ruleId);
        dataQualityTaskExecutionContext.setRuleType(dqRule.getType());
        dataQualityTaskExecutionContext.setRuleName(dqRule.getName());
        List ruleInputEntryList = this.processService.getRuleInputEntry(ruleId);
        if (CollectionUtils.isEmpty((Collection)ruleInputEntryList)) {
            log.error("Rule input entry list is empty, ruleId: {}", (Object)ruleId);
            return;
        }
        List executeSqlList = this.processService.getDqExecuteSql(ruleId);
        this.setComparisonParams(dataQualityTaskExecutionContext, config, ruleInputEntryList, executeSqlList);
        dataQualityTaskExecutionContext.setRuleInputEntryList(JSONUtils.toJsonString((Object)ruleInputEntryList));
        dataQualityTaskExecutionContext.setExecuteSqlList(JSONUtils.toJsonString((Object)executeSqlList));
        dataQualityTaskExecutionContext.setHdfsPath(PropertyUtils.getString((String)"resource.hdfs.fs.defaultFS") + PropertyUtils.getString((String)"data-quality.error.output.path", (String)("/user/" + tenantCode + "/data_quality_error_data")));
        this.setSourceConfig(dataQualityTaskExecutionContext, config);
        this.setTargetConfig(dataQualityTaskExecutionContext, config);
        this.setWriterConfig(dataQualityTaskExecutionContext);
        this.setStatisticsValueWriterConfig(dataQualityTaskExecutionContext);
    }

    private K8sTaskExecutionContext setK8sTaskRelation(TaskInstance taskInstance) {
        String clusterName;
        String configYaml;
        K8sTaskExecutionContext k8sTaskExecutionContext = null;
        String namespace = "";
        switch (taskInstance.getTaskType()) {
            case "K8S": 
            case "KUBEFLOW": {
                K8sTaskParameters k8sTaskParameters = (K8sTaskParameters)JSONUtils.parseObject((String)taskInstance.getTaskParams(), K8sTaskParameters.class);
                namespace = k8sTaskParameters.getNamespace();
                break;
            }
            case "SPARK": {
                SparkParameters sparkParameters = (SparkParameters)JSONUtils.parseObject((String)taskInstance.getTaskParams(), SparkParameters.class);
                if (!StringUtils.isNotEmpty((CharSequence)sparkParameters.getNamespace())) break;
                namespace = sparkParameters.getNamespace();
                break;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)namespace) && (configYaml = this.processService.findConfigYamlByName(clusterName = (String)JSONUtils.toMap((String)namespace).get("cluster"))) != null) {
            k8sTaskExecutionContext = new K8sTaskExecutionContext(configYaml, (String)JSONUtils.toMap((String)namespace).get("name"));
        }
        return k8sTaskExecutionContext;
    }

    private void setSourceConfig(DataQualityTaskExecutionContext dataQualityTaskExecutionContext, Map<String, String> config) {
        DataSource dataSource;
        if (StringUtils.isNotEmpty((CharSequence)config.get("src_datasource_id")) && (dataSource = this.processService.findDataSourceById(Integer.parseInt(config.get("src_datasource_id")))) != null) {
            ConnectorType srcConnectorType = ConnectorType.of((Integer)(DbType.of((int)Integer.parseInt(config.get("src_connector_type"))).isHive() ? 1 : 0));
            dataQualityTaskExecutionContext.setSourceConnectorType(srcConnectorType.getDescription());
            dataQualityTaskExecutionContext.setSourceType(dataSource.getType().getCode());
            dataQualityTaskExecutionContext.setSourceConnectionParams(dataSource.getConnectionParams());
        }
    }

    private void setComparisonParams(DataQualityTaskExecutionContext dataQualityTaskExecutionContext, Map<String, String> config, List<DqRuleInputEntry> ruleInputEntryList, List<DqRuleExecuteSql> executeSqlList) {
        if (config.get("comparison_type") != null) {
            int comparisonTypeId = Integer.parseInt(config.get("comparison_type"));
            if (comparisonTypeId > 1) {
                DqComparisonType type = this.processService.getComparisonTypeById(comparisonTypeId);
                if (type != null) {
                    DqRuleInputEntry comparisonName = new DqRuleInputEntry();
                    comparisonName.setField("comparison_name");
                    comparisonName.setData(type.getName());
                    ruleInputEntryList.add(comparisonName);
                    DqRuleInputEntry comparisonTable = new DqRuleInputEntry();
                    comparisonTable.setField("comparison_table");
                    comparisonTable.setData(type.getOutputTable());
                    ruleInputEntryList.add(comparisonTable);
                    if (executeSqlList == null) {
                        executeSqlList = new ArrayList<DqRuleExecuteSql>();
                    }
                    DqRuleExecuteSql dqRuleExecuteSql = new DqRuleExecuteSql();
                    dqRuleExecuteSql.setType(ExecuteSqlType.MIDDLE.getCode());
                    dqRuleExecuteSql.setIndex(1);
                    dqRuleExecuteSql.setSql(type.getExecuteSql());
                    dqRuleExecuteSql.setTableAlias(type.getOutputTable());
                    executeSqlList.add(0, dqRuleExecuteSql);
                    if (Boolean.TRUE.equals(type.getIsInnerSource())) {
                        dataQualityTaskExecutionContext.setComparisonNeedStatisticsValueTable(true);
                    }
                }
            } else if (comparisonTypeId == 1) {
                dataQualityTaskExecutionContext.setCompareWithFixedValue(true);
            }
        }
    }

    private void setTargetConfig(DataQualityTaskExecutionContext dataQualityTaskExecutionContext, Map<String, String> config) {
        DataSource dataSource;
        if (StringUtils.isNotEmpty((CharSequence)config.get("target_datasource_id")) && (dataSource = this.processService.findDataSourceById(Integer.parseInt(config.get("target_datasource_id")))) != null) {
            ConnectorType targetConnectorType = ConnectorType.of((Integer)(DbType.of((int)Integer.parseInt(config.get("target_connector_type"))).isHive() ? 1 : 0));
            dataQualityTaskExecutionContext.setTargetConnectorType(targetConnectorType.getDescription());
            dataQualityTaskExecutionContext.setTargetType(dataSource.getType().getCode());
            dataQualityTaskExecutionContext.setTargetConnectionParams(dataSource.getConnectionParams());
        }
    }

    private void setWriterConfig(DataQualityTaskExecutionContext dataQualityTaskExecutionContext) {
        DataSource dataSource = this.getDefaultDataSource();
        ConnectorType writerConnectorType = ConnectorType.of((Integer)(dataSource.getType().isHive() ? 1 : 0));
        dataQualityTaskExecutionContext.setWriterConnectorType(writerConnectorType.getDescription());
        dataQualityTaskExecutionContext.setWriterType(dataSource.getType().getCode());
        dataQualityTaskExecutionContext.setWriterConnectionParams(dataSource.getConnectionParams());
        dataQualityTaskExecutionContext.setWriterTable("t_ds_dq_execute_result");
    }

    public DataSource getDefaultDataSource() {
        DataSource dataSource = new DataSource();
        dataSource.setUserName(this.hikariDataSource.getUsername());
        JdbcInfo jdbcInfo = JdbcUrlParser.getJdbcInfo((String)this.hikariDataSource.getJdbcUrl());
        if (jdbcInfo != null) {
            DefaultConnectionParam baseConnectionParam = new DefaultConnectionParam();
            baseConnectionParam.setUser(this.hikariDataSource.getUsername());
            baseConnectionParam.setPassword(this.hikariDataSource.getPassword());
            baseConnectionParam.setDatabase(jdbcInfo.getDatabase());
            baseConnectionParam.setAddress(jdbcInfo.getAddress());
            baseConnectionParam.setJdbcUrl(jdbcInfo.getJdbcUrl());
            baseConnectionParam.setOther(jdbcInfo.getParams());
            dataSource.setType(DbType.of((int)JdbcUrlParser.getDbType((String)jdbcInfo.getDriverName()).getCode()));
            dataSource.setConnectionParams(JSONUtils.toJsonString((Object)baseConnectionParam));
        }
        return dataSource;
    }

    private void setStatisticsValueWriterConfig(DataQualityTaskExecutionContext dataQualityTaskExecutionContext) {
        DataSource dataSource = this.getDefaultDataSource();
        ConnectorType writerConnectorType = ConnectorType.of((Integer)(dataSource.getType().isHive() ? 1 : 0));
        dataQualityTaskExecutionContext.setStatisticsValueConnectorType(writerConnectorType.getDescription());
        dataQualityTaskExecutionContext.setStatisticsValueType(dataSource.getType().getCode());
        dataQualityTaskExecutionContext.setStatisticsValueWriterConnectionParams(dataSource.getConnectionParams());
        dataQualityTaskExecutionContext.setStatisticsValueTable("t_ds_dq_task_statistics_value");
    }
}

