/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.Optional;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.SlotCheckState;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.graph.IWorkflowGraph;
import org.apache.dolphinscheduler.server.master.graph.WorkflowGraphFactory;
import org.apache.dolphinscheduler.server.master.metrics.ProcessInstanceMetrics;
import org.apache.dolphinscheduler.server.master.registry.MasterSlotManager;
import org.apache.dolphinscheduler.server.master.runner.IWorkflowExecuteContext;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteContext;
import org.apache.dolphinscheduler.service.exceptions.CronParseException;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowExecuteContextFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowExecuteContextFactory.class);
    @Autowired
    private MasterSlotManager masterSlotManager;
    @Autowired
    private ProcessService processService;
    @Autowired
    private WorkflowGraphFactory workflowGraphFactory;
    @Autowired
    private MasterConfig masterConfig;

    public Optional<IWorkflowExecuteContext> createWorkflowExecuteRunnableContext(Command command) throws Exception {
        Optional<ProcessInstance> workflowInstanceOptional = this.createWorkflowInstance(command);
        if (!workflowInstanceOptional.isPresent()) {
            return Optional.empty();
        }
        ProcessInstance workflowInstance = workflowInstanceOptional.get();
        ProcessDefinition workflowDefinition = this.processService.findProcessDefinition(workflowInstance.getProcessDefinitionCode(), workflowInstance.getProcessDefinitionVersion());
        workflowInstance.setProcessDefinition(workflowDefinition);
        IWorkflowGraph workflowGraph = this.workflowGraphFactory.createWorkflowGraph(workflowInstance);
        return Optional.of(new WorkflowExecuteContext(workflowDefinition, workflowInstance, workflowGraph));
    }

    private Optional<ProcessInstance> createWorkflowInstance(Command command) throws CronParseException {
        long commandTransformStartTime = System.currentTimeMillis();
        SlotCheckState slotCheckState = this.slotCheck(command);
        if (slotCheckState.equals((Object)SlotCheckState.CHANGE) || slotCheckState.equals((Object)SlotCheckState.INJECT)) {
            log.info("Master handle command {} skip, slot check state: {}", (Object)command.getId(), (Object)slotCheckState);
            throw new RuntimeException("Slot check failed the current state: " + slotCheckState);
        }
        ProcessInstance processInstance = this.processService.handleCommand(this.masterConfig.getMasterAddress(), command);
        ProcessInstanceMetrics.recordProcessInstanceGenerateTime(System.currentTimeMillis() - commandTransformStartTime);
        return Optional.ofNullable(processInstance);
    }

    private SlotCheckState slotCheck(Command command) {
        int slot = this.masterSlotManager.getSlot();
        int masterSize = this.masterSlotManager.getMasterSize();
        SlotCheckState state = masterSize <= 0 ? SlotCheckState.CHANGE : (command.getId() % masterSize == slot ? SlotCheckState.PASS : SlotCheckState.INJECT);
        return state;
    }
}

