/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.runner.IWorkflowExecuteContext;
import org.apache.dolphinscheduler.server.master.runner.StateWheelExecuteThread;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

@Component
public class WorkflowExecuteThreadPool
extends ThreadPoolTaskExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowExecuteThreadPool.class);
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private ProcessInstanceExecCacheManager processInstanceExecCacheManager;
    @Autowired
    private StateWheelExecuteThread stateWheelExecuteThread;
    private ConcurrentHashMap<Integer, WorkflowExecuteRunnable> multiThreadFilterMap = new ConcurrentHashMap();

    @PostConstruct
    private void init() {
        this.setDaemon(true);
        this.setThreadNamePrefix("WorkflowExecuteThread-");
        this.setMaxPoolSize(this.masterConfig.getExecThreads());
        this.setCorePoolSize(this.masterConfig.getExecThreads());
    }

    public void submitStateEvent(StateEvent stateEvent) {
        WorkflowExecuteRunnable workflowExecuteThread = this.processInstanceExecCacheManager.getByProcessInstanceId(stateEvent.getProcessInstanceId());
        if (workflowExecuteThread == null) {
            log.warn("Submit state event error, cannot from workflowExecuteThread from cache manager, stateEvent:{}", (Object)stateEvent);
            return;
        }
        workflowExecuteThread.addStateEvent(stateEvent);
        log.info("Submit state event success, stateEvent: {}", (Object)stateEvent);
    }

    public void executeEvent(final WorkflowExecuteRunnable workflowExecuteThread) {
        if (!workflowExecuteThread.isStart() || workflowExecuteThread.eventSize() == 0) {
            return;
        }
        IWorkflowExecuteContext workflowExecuteRunnableContext = workflowExecuteThread.getWorkflowExecuteContext();
        final Integer workflowInstanceId = workflowExecuteRunnableContext.getWorkflowInstance().getId();
        if (this.multiThreadFilterMap.containsKey(workflowInstanceId)) {
            log.debug("The workflow has been executed by another thread");
            return;
        }
        this.multiThreadFilterMap.put(workflowInstanceId, workflowExecuteThread);
        ListenableFuture future = this.submitListenable(workflowExecuteThread::handleEvents);
        future.addCallback(new ListenableFutureCallback(){

            public void onFailure(Throwable ex) {
                LogUtils.setWorkflowInstanceIdMDC((Integer)workflowInstanceId);
                try {
                    log.error("Workflow instance events handle failed", ex);
                    WorkflowExecuteThreadPool.this.multiThreadFilterMap.remove(workflowInstanceId);
                }
                finally {
                    LogUtils.removeWorkflowInstanceIdMDC();
                }
            }

            public void onSuccess(Object result) {
                try {
                    LogUtils.setWorkflowInstanceIdMDC((Integer)workflowExecuteThread.getWorkflowExecuteContext().getWorkflowInstance().getId());
                    if (workflowExecuteThread.workFlowFinish() && workflowExecuteThread.eventSize() == 0) {
                        WorkflowExecuteThreadPool.this.stateWheelExecuteThread.removeProcess4TimeoutCheck(workflowExecuteThread.getWorkflowExecuteContext().getWorkflowInstance().getId());
                        WorkflowExecuteThreadPool.this.processInstanceExecCacheManager.removeByProcessInstanceId(workflowInstanceId);
                        log.info("Workflow instance is finished.");
                    }
                }
                catch (Exception e) {
                    log.error("Workflow instance is finished, but notify changed error", (Throwable)e);
                }
                finally {
                    WorkflowExecuteThreadPool.this.multiThreadFilterMap.remove(workflowInstanceId);
                    LogUtils.removeWorkflowInstanceIdMDC();
                }
            }
        });
    }
}

