/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.dispatcher;

import java.util.Optional;
import lombok.Generated;
import org.apache.dolphinscheduler.extract.base.client.SingletonJdkDynamicRpcClientProxyFactory;
import org.apache.dolphinscheduler.extract.base.utils.Host;
import org.apache.dolphinscheduler.extract.master.ILogicTaskInstanceOperator;
import org.apache.dolphinscheduler.extract.master.transportor.LogicTaskDispatchRequest;
import org.apache.dolphinscheduler.extract.master.transportor.LogicTaskDispatchResponse;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.exception.TaskDispatchException;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEventService;
import org.apache.dolphinscheduler.server.master.runner.BaseTaskDispatcher;
import org.apache.dolphinscheduler.server.master.runner.TaskExecuteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MasterTaskDispatcher
extends BaseTaskDispatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterTaskDispatcher.class);
    private final Optional<Host> masterTaskExecuteHost;

    public MasterTaskDispatcher(TaskEventService taskEventService, MasterConfig masterConfig) {
        super(taskEventService, masterConfig);
        this.masterTaskExecuteHost = Optional.of(Host.of((String)masterConfig.getMasterAddress()));
    }

    @Override
    protected void doDispatch(TaskExecuteRunnable taskExecuteRunnable) throws TaskDispatchException {
        TaskExecutionContext taskExecutionContext = taskExecuteRunnable.getTaskExecutionContext();
        try {
            ILogicTaskInstanceOperator taskInstanceOperator = (ILogicTaskInstanceOperator)SingletonJdkDynamicRpcClientProxyFactory.getProxyClient((String)taskExecutionContext.getHost(), ILogicTaskInstanceOperator.class);
            LogicTaskDispatchResponse logicTaskDispatchResponse = taskInstanceOperator.dispatchLogicTask(new LogicTaskDispatchRequest(taskExecuteRunnable.getTaskExecutionContext()));
            if (!logicTaskDispatchResponse.isDispatchSuccess()) {
                throw new TaskDispatchException(String.format("Dispatch LogicTask to %s failed, response is: %s", taskExecutionContext.getHost(), logicTaskDispatchResponse));
            }
        }
        catch (TaskDispatchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TaskDispatchException(String.format("Dispatch task to %s failed", taskExecutionContext.getHost()), e);
        }
    }

    @Override
    protected Optional<Host> getTaskInstanceDispatchHost(TaskExecuteRunnable taskExecutionContext) {
        return this.masterTaskExecuteHost;
    }
}

