/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.dispatcher;

import com.google.common.base.Preconditions;
import java.util.Optional;
import lombok.Generated;
import org.apache.dolphinscheduler.extract.base.client.SingletonJdkDynamicRpcClientProxyFactory;
import org.apache.dolphinscheduler.extract.base.utils.Host;
import org.apache.dolphinscheduler.extract.worker.ITaskInstanceOperator;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstanceDispatchRequest;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstanceDispatchResponse;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.dispatch.exceptions.WorkerGroupNotFoundException;
import org.apache.dolphinscheduler.server.master.dispatch.host.HostManager;
import org.apache.dolphinscheduler.server.master.exception.TaskDispatchException;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEventService;
import org.apache.dolphinscheduler.server.master.runner.BaseTaskDispatcher;
import org.apache.dolphinscheduler.server.master.runner.TaskExecuteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkerTaskDispatcher
extends BaseTaskDispatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerTaskDispatcher.class);
    private final HostManager hostManager;

    public WorkerTaskDispatcher(TaskEventService taskEventService, MasterConfig masterConfig, HostManager hostManager) {
        super(taskEventService, masterConfig);
        this.hostManager = (HostManager)Preconditions.checkNotNull((Object)hostManager);
    }

    @Override
    protected void doDispatch(TaskExecuteRunnable taskExecuteRunnable) throws TaskDispatchException {
        TaskExecutionContext taskExecutionContext = taskExecuteRunnable.getTaskExecutionContext();
        try {
            ITaskInstanceOperator taskInstanceOperator = (ITaskInstanceOperator)SingletonJdkDynamicRpcClientProxyFactory.getProxyClient((String)taskExecutionContext.getHost(), ITaskInstanceOperator.class);
            TaskInstanceDispatchResponse taskInstanceDispatchResponse = taskInstanceOperator.dispatchTask(new TaskInstanceDispatchRequest(taskExecuteRunnable.getTaskExecutionContext()));
            if (!taskInstanceDispatchResponse.isDispatchSuccess()) {
                throw new TaskDispatchException(String.format("Dispatch task to %s failed, response is: %s", taskExecutionContext.getHost(), taskInstanceDispatchResponse));
            }
        }
        catch (TaskDispatchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TaskDispatchException(String.format("Dispatch task to %s failed", taskExecutionContext.getHost()), e);
        }
    }

    @Override
    protected Optional<Host> getTaskInstanceDispatchHost(TaskExecuteRunnable taskExecuteRunnable) throws WorkerGroupNotFoundException {
        String workerGroup = taskExecuteRunnable.getTaskExecutionContext().getWorkerGroup();
        return this.hostManager.select(workerGroup);
    }
}

