/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.execute;

import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.log.TaskInstanceLogHeader;
import org.apache.dolphinscheduler.server.master.runner.execute.AsyncMasterTaskExecutor;
import org.apache.dolphinscheduler.server.master.runner.execute.AsyncTaskCallbackFunction;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecutionContextHolder;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecutorHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncTaskCallbackFunctionImpl
implements AsyncTaskCallbackFunction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncTaskCallbackFunctionImpl.class);
    private final AsyncMasterTaskExecutor asyncMasterTaskExecuteRunnable;

    public AsyncTaskCallbackFunctionImpl(@NonNull AsyncMasterTaskExecutor asyncMasterTaskExecuteRunnable) {
        if (asyncMasterTaskExecuteRunnable == null) {
            throw new NullPointerException("asyncMasterTaskExecuteRunnable is marked non-null but is null");
        }
        this.asyncMasterTaskExecuteRunnable = asyncMasterTaskExecuteRunnable;
    }

    @Override
    public void executeSuccess() {
        this.asyncMasterTaskExecuteRunnable.getTaskExecutionContext().setCurrentExecutionStatus(TaskExecutionStatus.SUCCESS);
        this.executeFinished();
    }

    @Override
    public void executeFailed() {
        this.asyncMasterTaskExecuteRunnable.getTaskExecutionContext().setCurrentExecutionStatus(TaskExecutionStatus.FAILURE);
        this.executeFinished();
    }

    @Override
    public void executeThrowing(Throwable throwable) {
        this.asyncMasterTaskExecuteRunnable.afterThrowing(throwable);
    }

    private void executeFinished() {
        TaskInstanceLogHeader.printFinalizeTaskHeader();
        int taskInstanceId = this.asyncMasterTaskExecuteRunnable.getTaskExecutionContext().getTaskInstanceId();
        MasterTaskExecutionContextHolder.removeTaskExecutionContext(taskInstanceId);
        MasterTaskExecutorHolder.removeMasterTaskExecutor(taskInstanceId);
        log.info("Task execute finished, removed the TaskExecutionContext");
        this.asyncMasterTaskExecuteRunnable.sendTaskResult();
        log.info("Execute task finished, will send the task execute result to master, the current task execute result is {}", (Object)this.asyncMasterTaskExecuteRunnable.getTaskExecutionContext().getCurrentExecutionStatus().name());
        this.asyncMasterTaskExecuteRunnable.closeLogAppender();
    }
}

