/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.execute;

import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.runner.execute.AsyncMasterTaskExecutor;
import org.apache.dolphinscheduler.server.master.runner.execute.IMasterTaskExecutorThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MasterAsyncTaskExecutorThreadPool
implements IMasterTaskExecutorThreadPool<AsyncMasterTaskExecutor> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterAsyncTaskExecutorThreadPool.class);
    private final ThreadPoolExecutor threadPoolExecutor;

    public MasterAsyncTaskExecutorThreadPool(MasterConfig masterConfig) {
        this.threadPoolExecutor = ThreadUtils.newDaemonFixedThreadExecutor((String)"MasterAsyncTaskExecutorThreadPool", (int)masterConfig.getMasterSyncTaskExecutorThreadPoolSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean submitMasterTaskExecutor(AsyncMasterTaskExecutor asyncMasterTaskExecutor) {
        Class<MasterAsyncTaskExecutorThreadPool> clazz = MasterAsyncTaskExecutorThreadPool.class;
        synchronized (MasterAsyncTaskExecutorThreadPool.class) {
            this.threadPoolExecutor.execute(asyncMasterTaskExecutor);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    @Override
    public boolean removeMasterTaskExecutor(AsyncMasterTaskExecutor asyncMasterTaskExecutor) {
        return this.threadPoolExecutor.remove(asyncMasterTaskExecutor);
    }

    ThreadPoolExecutor getThreadPool() {
        return this.threadPoolExecutor;
    }
}

