/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.execute;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.dolphinscheduler.server.master.runner.execute.AsyncMasterTaskExecutorFactory;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecutor;
import org.apache.dolphinscheduler.server.master.runner.execute.MasterTaskExecutorFactory;
import org.apache.dolphinscheduler.server.master.runner.execute.SyncMasterTaskExecutorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MasterTaskExecutorFactoryBuilder {
    @Autowired
    private AsyncMasterTaskExecutorFactory asyncMasterTaskExecutorFactory;
    @Autowired
    private SyncMasterTaskExecutorFactory syncMasterTaskExecutorFactory;
    private static final Set<String> ASYNC_TASK_TYPE = Sets.newHashSet((Object[])new String[]{"DEPENDENT", "SUB_PROCESS", "DYNAMIC"});

    public MasterTaskExecutorFactory<? extends MasterTaskExecutor> createMasterTaskExecutorFactory(String taskType) {
        if (ASYNC_TASK_TYPE.contains(taskType)) {
            return this.asyncMasterTaskExecutorFactory;
        }
        return this.syncMasterTaskExecutorFactory;
    }
}

