/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.listener;

import lombok.Generated;
import org.apache.dolphinscheduler.extract.master.transportor.TaskInstanceExecutionFinishEvent;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEvent;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEventService;
import org.apache.dolphinscheduler.server.master.runner.listener.ITaskInstanceExecutionEventListenFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskInstanceExecutionResultEventListenFunction
implements ITaskInstanceExecutionEventListenFunction<TaskInstanceExecutionFinishEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskInstanceExecutionResultEventListenFunction.class);
    @Autowired
    private TaskEventService taskEventService;

    @Override
    public void handleTaskInstanceExecutionEvent(TaskInstanceExecutionFinishEvent taskInstanceExecutionFinishEvent) {
        TaskEvent taskResultEvent = TaskEvent.newResultEvent(taskInstanceExecutionFinishEvent);
        try {
            LogUtils.setWorkflowAndTaskInstanceIDMDC((Integer)taskResultEvent.getProcessInstanceId(), (Integer)taskResultEvent.getTaskInstanceId());
            log.info("Received TaskInstanceExecutionFinishEvent: {}", (Object)taskResultEvent);
            this.taskEventService.addEvent(taskResultEvent);
        }
        finally {
            LogUtils.removeWorkflowAndTaskInstanceIdMDC();
        }
    }
}

