/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.listener;

import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.extract.master.transportor.WorkflowInstanceStateChangeEvent;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.event.TaskStateEvent;
import org.apache.dolphinscheduler.server.master.event.WorkflowStateEvent;
import org.apache.dolphinscheduler.server.master.processor.queue.StateEventResponseService;
import org.apache.dolphinscheduler.server.master.runner.listener.ITaskInstanceExecutionEventListenFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskInstanceStateEventListenFunction
implements ITaskInstanceExecutionEventListenFunction<WorkflowInstanceStateChangeEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskInstanceStateEventListenFunction.class);
    @Autowired
    private StateEventResponseService stateEventResponseService;

    @Override
    public void handleTaskInstanceExecutionEvent(WorkflowInstanceStateChangeEvent taskInstanceInstanceStateChangeEvent) {
        StateEvent stateEvent = taskInstanceInstanceStateChangeEvent.getDestTaskInstanceId() == 0 ? this.createWorkflowStateEvent(taskInstanceInstanceStateChangeEvent) : this.createTaskStateEvent(taskInstanceInstanceStateChangeEvent);
        try {
            LogUtils.setWorkflowAndTaskInstanceIDMDC((Integer)stateEvent.getProcessInstanceId(), (Integer)stateEvent.getTaskInstanceId());
            log.info("Received state change command, event: {}", (Object)stateEvent);
            this.stateEventResponseService.addStateChangeEvent(stateEvent);
        }
        finally {
            LogUtils.removeWorkflowAndTaskInstanceIdMDC();
        }
    }

    private TaskStateEvent createTaskStateEvent(WorkflowInstanceStateChangeEvent workflowStateEventChangeRequest) {
        return TaskStateEvent.builder().processInstanceId(workflowStateEventChangeRequest.getDestProcessInstanceId()).taskInstanceId(workflowStateEventChangeRequest.getDestTaskInstanceId()).type(StateEventType.TASK_STATE_CHANGE).key(workflowStateEventChangeRequest.getKey()).build();
    }

    private WorkflowStateEvent createWorkflowStateEvent(WorkflowInstanceStateChangeEvent workflowStateEventChangeRequest) {
        WorkflowExecutionStatus workflowExecutionStatus = workflowStateEventChangeRequest.getSourceStatus();
        if (workflowStateEventChangeRequest.getSourceProcessInstanceId() != workflowStateEventChangeRequest.getDestProcessInstanceId()) {
            workflowExecutionStatus = WorkflowExecutionStatus.RUNNING_EXECUTION;
        }
        return WorkflowStateEvent.builder().processInstanceId(workflowStateEventChangeRequest.getDestProcessInstanceId()).type(StateEventType.PROCESS_STATE_CHANGE).status(workflowExecutionStatus).key(workflowStateEventChangeRequest.getKey()).build();
    }
}

