/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.operator;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.server.master.runner.DefaultTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.GlobalTaskDispatchWaitingQueue;
import org.apache.dolphinscheduler.server.master.runner.operator.TaskExecuteRunnableOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTaskExecuteRunnableDispatchOperator
implements TaskExecuteRunnableOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseTaskExecuteRunnableDispatchOperator.class);
    private final GlobalTaskDispatchWaitingQueue globalTaskDispatchWaitingQueue;
    private final TaskInstanceDao taskInstanceDao;

    public BaseTaskExecuteRunnableDispatchOperator(GlobalTaskDispatchWaitingQueue globalTaskDispatchWaitingQueue, TaskInstanceDao taskInstanceDao) {
        this.globalTaskDispatchWaitingQueue = globalTaskDispatchWaitingQueue;
        this.taskInstanceDao = taskInstanceDao;
    }

    @Override
    public void operate(DefaultTaskExecuteRunnable taskExecuteRunnable) {
        long remainTime = taskExecuteRunnable.getDelay(TimeUnit.SECONDS);
        TaskInstance taskInstance = taskExecuteRunnable.getTaskInstance();
        if (remainTime > 0L) {
            taskInstance.setState(TaskExecutionStatus.DELAY_EXECUTION);
            this.taskInstanceDao.updateById((Object)taskInstance);
            log.info("Current taskInstance: {} is choose delay execution, delay time: {}/s, remainTime: {}/s", new Object[]{taskInstance.getName(), taskInstance.getDelayTime(), remainTime});
        }
        this.globalTaskDispatchWaitingQueue.submitTaskExecuteRunnable(taskExecuteRunnable);
    }
}

