/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.operator;

import java.util.Date;
import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.server.master.runner.DefaultTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.operator.TaskExecuteRunnableOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTaskExecuteRunnableKillOperator
implements TaskExecuteRunnableOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseTaskExecuteRunnableKillOperator.class);
    private final TaskInstanceDao taskInstanceDao;

    public BaseTaskExecuteRunnableKillOperator(TaskInstanceDao taskInstanceDao) {
        this.taskInstanceDao = taskInstanceDao;
    }

    @Override
    public void operate(DefaultTaskExecuteRunnable taskExecuteRunnable) {
        TaskInstance taskInstance = taskExecuteRunnable.getTaskInstance();
        log.info("Begin to kill task instance: {}", (Object)taskInstance.getName());
        if (taskInstance.getState().isFinished()) {
            log.info("The task stance {} is finished, no need to kill", (Object)taskInstance.getName());
            return;
        }
        try {
            this.killTaskInstanceInDB(taskInstance);
            this.killRemoteTaskInstanceInThreadPool(taskInstance);
        }
        catch (Exception ex) {
            log.error("Kill task instance {} failed", (Object)taskInstance.getName(), (Object)ex);
        }
    }

    protected abstract void killRemoteTaskInstanceInThreadPool(TaskInstance var1);

    private void killTaskInstanceInDB(TaskInstance taskInstance) {
        taskInstance.setState(TaskExecutionStatus.KILL);
        taskInstance.setEndTime(new Date());
        this.taskInstanceDao.updateById((Object)taskInstance);
    }
}

