/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.operator;

import java.util.Date;
import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.server.master.runner.DefaultTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.operator.TaskExecuteRunnableOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTaskExecuteRunnableTimeoutOperator
implements TaskExecuteRunnableOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseTaskExecuteRunnableTimeoutOperator.class);
    private TaskInstanceDao taskInstanceDao;

    public BaseTaskExecuteRunnableTimeoutOperator(TaskInstanceDao taskInstanceDao) {
        this.taskInstanceDao = taskInstanceDao;
    }

    @Override
    public void operate(DefaultTaskExecuteRunnable taskExecuteRunnable) {
        TaskInstance taskInstance = taskExecuteRunnable.getTaskInstance();
        TaskTimeoutStrategy taskTimeoutStrategy = taskInstance.getTaskDefine().getTimeoutNotifyStrategy();
        if (TaskTimeoutStrategy.FAILED != taskTimeoutStrategy && TaskTimeoutStrategy.WARNFAILED != taskTimeoutStrategy) {
            log.warn("TaskInstance: {} timeout, the current timeout strategy is {}, will continue running", (Object)taskInstance.getName(), (Object)taskTimeoutStrategy.name());
            return;
        }
        try {
            this.timeoutTaskInstanceInDB(taskInstance);
            this.killRemoteTaskInstanceInThreadPool(taskInstance);
            log.info("TaskInstance: {} timeout, killed the task instance", (Object)taskInstance.getName());
        }
        catch (Exception ex) {
            log.error("TaskInstance timeout {} failed", (Object)taskInstance.getName(), (Object)ex);
        }
    }

    protected abstract void killRemoteTaskInstanceInThreadPool(TaskInstance var1);

    private void timeoutTaskInstanceInDB(TaskInstance taskInstance) {
        taskInstance.setState(TaskExecutionStatus.FAILURE);
        taskInstance.setEndTime(new Date());
        this.taskInstanceDao.updateById((Object)taskInstance);
    }
}

