/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.operator;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.extract.base.client.SingletonJdkDynamicRpcClientProxyFactory;
import org.apache.dolphinscheduler.extract.master.ILogicTaskInstanceOperator;
import org.apache.dolphinscheduler.extract.master.transportor.LogicTaskPauseRequest;
import org.apache.dolphinscheduler.extract.master.transportor.LogicTaskPauseResponse;
import org.apache.dolphinscheduler.server.master.runner.operator.BaseTaskExecuteRunnablePauseOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LogicTaskExecuteRunnablePauseOperator
extends BaseTaskExecuteRunnablePauseOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogicTaskExecuteRunnablePauseOperator.class);

    @Override
    protected void pauseRemoteTaskInstanceInThreadPool(TaskInstance taskInstance) {
        if (StringUtils.isEmpty((CharSequence)taskInstance.getHost())) {
            log.info("The LogicTaskInstance: {}'s host is null, no need to pauseRemoteTaskInstance", (Object)taskInstance.getName());
            return;
        }
        ILogicTaskInstanceOperator taskInstanceOperator = (ILogicTaskInstanceOperator)SingletonJdkDynamicRpcClientProxyFactory.getProxyClient((String)taskInstance.getHost(), ILogicTaskInstanceOperator.class);
        LogicTaskPauseRequest logicTaskPauseRequest = new LogicTaskPauseRequest(taskInstance.getId().intValue());
        LogicTaskPauseResponse logicTaskPauseResponse = taskInstanceOperator.pauseLogicTask(logicTaskPauseRequest);
        log.info("Pause LogicTaskInstance: {} on host: {} with response: {}", new Object[]{taskInstance.getName(), taskInstance.getHost(), logicTaskPauseResponse});
    }
}

