/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.operator;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.extract.base.client.SingletonJdkDynamicRpcClientProxyFactory;
import org.apache.dolphinscheduler.extract.master.ILogicTaskInstanceOperator;
import org.apache.dolphinscheduler.extract.master.transportor.LogicTaskKillRequest;
import org.apache.dolphinscheduler.extract.master.transportor.LogicTaskKillResponse;
import org.apache.dolphinscheduler.server.master.runner.operator.BaseTaskExecuteRunnableTimeoutOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LogicTaskExecuteRunnableTimeoutOperator
extends BaseTaskExecuteRunnableTimeoutOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogicTaskExecuteRunnableTimeoutOperator.class);

    public LogicTaskExecuteRunnableTimeoutOperator(TaskInstanceDao taskInstanceDao) {
        super(taskInstanceDao);
    }

    @Override
    protected void killRemoteTaskInstanceInThreadPool(TaskInstance taskInstance) {
        if (StringUtils.isEmpty((CharSequence)taskInstance.getHost())) {
            log.info("The LogicTaskInstance: {}'s host is null, no need to killRemoteTaskInstance", (Object)taskInstance.getId());
            return;
        }
        ILogicTaskInstanceOperator iLogicTaskInstanceOperator = (ILogicTaskInstanceOperator)SingletonJdkDynamicRpcClientProxyFactory.getProxyClient((String)taskInstance.getHost(), ILogicTaskInstanceOperator.class);
        LogicTaskKillRequest taskInstanceKillRequest = new LogicTaskKillRequest(taskInstance.getId().intValue());
        LogicTaskKillResponse taskInstanceKillResponse = iLogicTaskInstanceOperator.killLogicTask(taskInstanceKillRequest);
        log.info("Timeout kill LogicTaskInstance {} on host {} with response {}", new Object[]{taskInstance.getName(), taskInstance.getHost(), taskInstanceKillResponse});
    }
}

