/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.operator;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.extract.base.client.SingletonJdkDynamicRpcClientProxyFactory;
import org.apache.dolphinscheduler.extract.worker.ITaskInstanceOperator;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstancePauseRequest;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstancePauseResponse;
import org.apache.dolphinscheduler.server.master.runner.DefaultTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.operator.TaskExecuteRunnableOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskExecuteRunnablePauseOperator
implements TaskExecuteRunnableOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecuteRunnablePauseOperator.class);

    @Override
    public void operate(DefaultTaskExecuteRunnable taskExecuteRunnable) {
        try {
            this.pauseRemoteTaskInstanceInThreadPool(taskExecuteRunnable.getTaskInstance());
        }
        catch (Exception e) {
            log.error("Pause DefaultTaskExecuteRunnable failed", (Throwable)e);
        }
    }

    private void pauseRemoteTaskInstanceInThreadPool(TaskInstance taskInstance) {
        if (StringUtils.isEmpty((CharSequence)taskInstance.getHost())) {
            log.info("The TaskInstance: {} host is null, no need to pauseRemoteTaskInstance", (Object)taskInstance.getName());
            return;
        }
        ITaskInstanceOperator taskInstanceOperator = (ITaskInstanceOperator)SingletonJdkDynamicRpcClientProxyFactory.getProxyClient((String)taskInstance.getHost(), ITaskInstanceOperator.class);
        TaskInstancePauseRequest taskInstancePauseRequest = new TaskInstancePauseRequest(taskInstance.getId());
        TaskInstancePauseResponse taskInstancePauseResponse = taskInstanceOperator.pauseTask(taskInstancePauseRequest);
        log.info("Pause TaskInstance: {} on host: {} with response: {}", new Object[]{taskInstance.getName(), taskInstance.getHost(), taskInstancePauseResponse});
    }
}

