/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.operator;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.extract.base.client.SingletonJdkDynamicRpcClientProxyFactory;
import org.apache.dolphinscheduler.extract.worker.ITaskInstanceOperator;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstanceKillRequest;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstanceKillResponse;
import org.apache.dolphinscheduler.server.master.runner.operator.BaseTaskExecuteRunnableTimeoutOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskExecuteRunnableTimeoutOperator
extends BaseTaskExecuteRunnableTimeoutOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecuteRunnableTimeoutOperator.class);

    public TaskExecuteRunnableTimeoutOperator(TaskInstanceDao taskInstanceDao) {
        super(taskInstanceDao);
    }

    @Override
    protected void killRemoteTaskInstanceInThreadPool(TaskInstance taskInstance) {
        if (StringUtils.isEmpty((CharSequence)taskInstance.getHost())) {
            log.info("TaskInstance {} host is empty, no need to killRemoteTask", (Object)taskInstance.getName());
            return;
        }
        ITaskInstanceOperator iTaskInstanceOperator = (ITaskInstanceOperator)SingletonJdkDynamicRpcClientProxyFactory.getProxyClient((String)taskInstance.getHost(), ITaskInstanceOperator.class);
        TaskInstanceKillRequest taskInstanceKillRequest = new TaskInstanceKillRequest(taskInstance.getId());
        TaskInstanceKillResponse taskInstanceKillResponse = iTaskInstanceOperator.killTask(taskInstanceKillRequest);
        log.info("Timeout kill TaskInstance {} in host {} with response {}", new Object[]{taskInstance.getName(), taskInstance.getHost(), taskInstanceKillResponse});
    }
}

