/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task.blocking;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.BlockingOpportunity;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependResult;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependentRelation;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentItem;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentTaskModel;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.BlockingParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.DependentParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.DependentUtils;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.exception.MasterTaskExecuteException;
import org.apache.dolphinscheduler.server.master.runner.task.BaseSyncLogicTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingLogicTask
extends BaseSyncLogicTask<BlockingParameters> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BlockingLogicTask.class);
    public static final String TASK_TYPE = "BLOCKING";
    private final ProcessInstanceExecCacheManager processInstanceExecCacheManager;
    private final ProcessInstanceDao processInstanceDao;
    private final TaskInstanceDao taskInstanceDao;

    public BlockingLogicTask(TaskExecutionContext taskExecutionContext, ProcessInstanceExecCacheManager processInstanceExecCacheManager, ProcessInstanceDao processInstanceDao, TaskInstanceDao taskInstanceDao) {
        super(taskExecutionContext, (AbstractParameters)JSONUtils.parseObject((String)taskExecutionContext.getTaskParams(), (TypeReference)new TypeReference<BlockingParameters>(){}));
        this.processInstanceExecCacheManager = processInstanceExecCacheManager;
        this.processInstanceDao = processInstanceDao;
        this.taskInstanceDao = taskInstanceDao;
    }

    @Override
    public void handle() throws MasterTaskExecuteException {
        DependResult conditionResult = this.calculateConditionResult();
        DependResult expected = ((BlockingParameters)this.taskParameters).getBlockingOpportunity().equals(BlockingOpportunity.BLOCKING_ON_SUCCESS.getDesc()) ? DependResult.SUCCESS : DependResult.FAILED;
        boolean isBlocked = expected == conditionResult;
        log.info("blocking opportunity: expected-->{}, actual-->{}", (Object)expected, (Object)conditionResult);
        ProcessInstance workflowInstance = this.processInstanceExecCacheManager.getByProcessInstanceId(this.taskExecutionContext.getProcessInstanceId()).getWorkflowExecuteContext().getWorkflowInstance();
        workflowInstance.setBlocked(isBlocked);
        if (isBlocked) {
            workflowInstance.setStateWithDesc(WorkflowExecutionStatus.READY_BLOCK, "ready block");
        }
        this.taskExecutionContext.setCurrentExecutionStatus(TaskExecutionStatus.SUCCESS);
    }

    private DependResult calculateConditionResult() throws MasterTaskExecuteException {
        Map<Long, TaskInstance> completeTaskList = this.taskInstanceDao.queryValidTaskListByWorkflowInstanceId(Integer.valueOf(this.taskExecutionContext.getProcessInstanceId()), this.taskExecutionContext.getTestFlag()).stream().collect(Collectors.toMap(TaskInstance::getTaskCode, Function.identity()));
        TaskInstance taskInstance = this.processInstanceExecCacheManager.getByProcessInstanceId(this.taskExecutionContext.getProcessInstanceId()).getTaskInstance(this.taskExecutionContext.getTaskInstanceId()).orElseThrow(() -> new MasterTaskExecuteException("Task instance not found"));
        DependentParameters dependentParameters = taskInstance.getDependency();
        ArrayList<DependResult> tempResultList = new ArrayList<DependResult>();
        for (DependentTaskModel dependentTaskModel : dependentParameters.getDependTaskList()) {
            ArrayList<DependResult> itemDependResult = new ArrayList<DependResult>();
            for (DependentItem item : dependentTaskModel.getDependItemList()) {
                itemDependResult.add(this.getDependResultForItem(item, completeTaskList));
            }
            DependResult tempResult = DependentUtils.getDependResultForRelation((DependentRelation)dependentTaskModel.getRelation(), itemDependResult);
            tempResultList.add(tempResult);
        }
        return DependentUtils.getDependResultForRelation((DependentRelation)dependentParameters.getRelation(), tempResultList);
    }

    private DependResult getDependResultForItem(DependentItem item, Map<Long, TaskInstance> completeTaskList) {
        DependResult dependResult = DependResult.SUCCESS;
        if (!completeTaskList.containsKey(item.getDepTaskCode())) {
            log.info("depend item: {} have not completed yet.", (Object)item.getDepTaskCode());
            dependResult = DependResult.FAILED;
            return dependResult;
        }
        TaskInstance taskInstance = completeTaskList.get(item.getDepTaskCode());
        if (taskInstance.getState() != item.getStatus()) {
            log.info("depend item : {} expect status: {}, actual status: {}", new Object[]{item.getDepTaskCode(), item.getStatus(), taskInstance.getState().name()});
            dependResult = DependResult.FAILED;
        }
        log.info("Dependent item complete {} {},{}", new Object[]{":||", item.getDepTaskCode(), dependResult});
        return dependResult;
    }
}

