/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task.condition;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependResult;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependentRelation;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentItem;
import org.apache.dolphinscheduler.plugin.task.api.parameters.DependentParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.DependentUtils;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.exception.LogicTaskInitializeException;
import org.apache.dolphinscheduler.server.master.runner.task.BaseSyncLogicTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionLogicTask
extends BaseSyncLogicTask<DependentParameters> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConditionLogicTask.class);
    public static final String TASK_TYPE = "CONDITIONS";
    private final TaskInstanceDao taskInstanceDao;
    private final ProcessInstanceDao workflowInstanceDao;

    public ConditionLogicTask(TaskExecutionContext taskExecutionContext, ProcessInstanceExecCacheManager processInstanceExecCacheManager, TaskInstanceDao taskInstanceDao, ProcessInstanceDao workflowInstanceDao) throws LogicTaskInitializeException {
        super(taskExecutionContext, processInstanceExecCacheManager.getByProcessInstanceId(taskExecutionContext.getProcessInstanceId()).getTaskInstance(taskExecutionContext.getTaskInstanceId()).orElseThrow(() -> new LogicTaskInitializeException("Cannot find the task instance in workflow execute runnable")).getDependency());
        this.taskInstanceDao = taskInstanceDao;
        this.workflowInstanceDao = workflowInstanceDao;
    }

    @Override
    public void handle() {
        DependResult conditionResult = this.calculateConditionResult();
        TaskExecutionStatus taskExecutionStatus = conditionResult == DependResult.SUCCESS ? TaskExecutionStatus.SUCCESS : TaskExecutionStatus.FAILURE;
        log.info("The condition result is {}, task instance statue will be: {}", (Object)conditionResult, (Object)taskExecutionStatus);
        this.taskExecutionContext.setCurrentExecutionStatus(taskExecutionStatus);
    }

    private DependResult calculateConditionResult() {
        ProcessInstance processInstance = (ProcessInstance)this.workflowInstanceDao.queryById((Serializable)Integer.valueOf(this.taskExecutionContext.getProcessInstanceId()));
        List taskInstances = this.taskInstanceDao.queryValidTaskListByWorkflowInstanceId(processInstance.getId(), processInstance.getTestFlag());
        Map taskInstanceMap = taskInstances.stream().collect(Collectors.toMap(TaskInstance::getTaskCode, Function.identity()));
        List dependResults = ((DependentParameters)this.taskParameters).getDependTaskList().stream().map(dependentTaskModel -> DependentUtils.getDependResultForRelation((DependentRelation)dependentTaskModel.getRelation(), dependentTaskModel.getDependItemList().stream().map(dependentItem -> this.getDependResultForItem((DependentItem)dependentItem, taskInstanceMap)).collect(Collectors.toList()))).collect(Collectors.toList());
        return DependentUtils.getDependResultForRelation((DependentRelation)((DependentParameters)this.taskParameters).getRelation(), dependResults);
    }

    private DependResult getDependResultForItem(DependentItem item, Map<Long, TaskInstance> taskInstanceMap) {
        TaskInstance taskInstance = taskInstanceMap.get(item.getDepTaskCode());
        if (taskInstance == null) {
            log.info("The depend item: {} has not completed yet", (Object)DependResult.FAILED);
            log.info("The dependent result will be {}", (Object)DependResult.FAILED);
            return DependResult.FAILED;
        }
        DependResult dependResult = Objects.equals(item.getStatus(), taskInstance.getState()) ? DependResult.SUCCESS : DependResult.FAILED;
        log.info("The depend item: {}", (Object)item);
        log.info("Expect status: {}", (Object)item.getStatus());
        log.info("Actual status: {}", (Object)taskInstance.getState());
        log.info("The dependent result will be: {}", (Object)dependResult);
        return dependResult;
    }
}

