/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task.dependent;

import java.util.Date;
import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.ProcessDefinitionDao;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceDao;
import org.apache.dolphinscheduler.dao.repository.ProjectDao;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.parameters.DependentParameters;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.exception.LogicTaskInitializeException;
import org.apache.dolphinscheduler.server.master.exception.MasterTaskExecuteException;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.execute.AsyncTaskExecuteFunction;
import org.apache.dolphinscheduler.server.master.runner.task.BaseAsyncLogicTask;
import org.apache.dolphinscheduler.server.master.runner.task.dependent.DependentAsyncTaskExecuteFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependentLogicTask
extends BaseAsyncLogicTask<DependentParameters> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DependentLogicTask.class);
    public static final String TASK_TYPE = "DEPENDENT";
    private final ProjectDao projectDao;
    private final ProcessDefinitionDao processDefinitionDao;
    private final TaskDefinitionDao taskDefinitionDao;
    private final TaskInstanceDao taskInstanceDao;
    private final ProcessInstanceDao processInstanceDao;
    private final ProcessInstanceExecCacheManager processInstanceExecCacheManager;

    public DependentLogicTask(TaskExecutionContext taskExecutionContext, ProjectDao projectDao, ProcessDefinitionDao processDefinitionDao, TaskDefinitionDao taskDefinitionDao, TaskInstanceDao taskInstanceDao, ProcessInstanceDao processInstanceDao, ProcessInstanceExecCacheManager processInstanceExecCacheManager) throws LogicTaskInitializeException {
        super(taskExecutionContext, processInstanceExecCacheManager.getByProcessInstanceId(taskExecutionContext.getProcessInstanceId()).getTaskInstance(taskExecutionContext.getTaskInstanceId()).orElseThrow(() -> new LogicTaskInitializeException("Cannot find the task instance in workflow execute runnable")).getDependency());
        this.projectDao = projectDao;
        this.processDefinitionDao = processDefinitionDao;
        this.taskDefinitionDao = taskDefinitionDao;
        this.taskInstanceDao = taskInstanceDao;
        this.processInstanceDao = processInstanceDao;
        this.processInstanceExecCacheManager = processInstanceExecCacheManager;
    }

    @Override
    public AsyncTaskExecuteFunction getAsyncTaskExecuteFunction() {
        return new DependentAsyncTaskExecuteFunction(this.taskExecutionContext, (DependentParameters)this.taskParameters, this.projectDao, this.processDefinitionDao, this.taskDefinitionDao, this.taskInstanceDao, this.processInstanceDao);
    }

    @Override
    public void pause() throws MasterTaskExecuteException {
        WorkflowExecuteRunnable workflowExecuteRunnable = this.processInstanceExecCacheManager.getByProcessInstanceId(this.taskExecutionContext.getProcessInstanceId());
        if (workflowExecuteRunnable == null) {
            log.error("Cannot find the WorkflowExecuteRunnable");
            return;
        }
        TaskInstance taskInstance = workflowExecuteRunnable.getTaskInstance(this.taskExecutionContext.getTaskInstanceId()).orElse(null);
        if (taskInstance == null) {
            log.error("Cannot find the TaskInstance in workflowExecuteRunnable");
            return;
        }
        taskInstance.setState(TaskExecutionStatus.PAUSE);
        taskInstance.setEndTime(new Date());
        this.taskInstanceDao.upsertTaskInstance(taskInstance);
        super.pause();
    }
}

