/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task.dynamic;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;

public class DynamicCommandUtils {
    public static Command createCommand(ProcessInstance processInstance, Long subProcessDefinitionCode, Integer subProcessDefinitionVersion, Map<String, String> parameters) {
        Command command = new Command();
        if (processInstance.getCommandType().equals((Object)CommandType.START_PROCESS)) {
            command.setCommandType(CommandType.DYNAMIC_GENERATION);
        } else {
            command.setCommandType(processInstance.getCommandType());
        }
        command.setProcessDefinitionCode(subProcessDefinitionCode.longValue());
        command.setProcessDefinitionVersion(subProcessDefinitionVersion.intValue());
        command.setTaskDependType(TaskDependType.TASK_POST);
        command.setFailureStrategy(processInstance.getFailureStrategy());
        command.setWarningType(processInstance.getWarningType());
        String globalParams = processInstance.getGlobalParams();
        if (StringUtils.isNotEmpty((CharSequence)globalParams)) {
            ArrayList parentParams = Lists.newArrayList((Iterable)JSONUtils.toList((String)globalParams, Property.class));
            for (Property parentParam : parentParams) {
                parameters.put(parentParam.getProp(), parentParam.getValue());
            }
        }
        DynamicCommandUtils.addDataToCommandParam(command, "StartParams", JSONUtils.toJsonString(parameters));
        command.setExecutorId(processInstance.getExecutorId());
        command.setWarningGroupId(processInstance.getWarningGroupId());
        command.setProcessInstancePriority(processInstance.getProcessInstancePriority());
        command.setWorkerGroup(processInstance.getWorkerGroup());
        command.setDryRun(processInstance.getDryRun());
        return command;
    }

    public static String getDataFromCommandParam(String commandParam, String key) {
        Map cmdParam = JSONUtils.toMap((String)commandParam);
        return (String)cmdParam.get(key);
    }

    static void addDataToCommandParam(Command command, String key, String data) {
        HashMap<String, String> cmdParam = JSONUtils.toMap((String)command.getCommandParam());
        if (cmdParam == null) {
            cmdParam = new HashMap<String, String>();
        }
        cmdParam.put(key, data);
        command.setCommandParam(JSONUtils.toJsonString(cmdParam));
    }
}

