/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.taskgroup;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.TaskGroupQueueStatus;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskGroup;
import org.apache.dolphinscheduler.dao.entity.TaskGroupQueue;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceDao;
import org.apache.dolphinscheduler.dao.repository.TaskGroupDao;
import org.apache.dolphinscheduler.dao.repository.TaskGroupQueueDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.extract.base.client.SingletonJdkDynamicRpcClientProxyFactory;
import org.apache.dolphinscheduler.extract.master.IWorkflowInstanceService;
import org.apache.dolphinscheduler.extract.master.transportor.TaskInstanceWakeupRequest;
import org.apache.dolphinscheduler.extract.master.transportor.TaskInstanceWakeupResponse;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskGroupCoordinator
extends BaseDaemonThread {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskGroupCoordinator.class);
    @Autowired
    private RegistryClient registryClient;
    @Autowired
    private TaskGroupDao taskGroupDao;
    @Autowired
    private TaskGroupQueueDao taskGroupQueueDao;
    @Autowired
    private TaskInstanceDao taskInstanceDao;
    @Autowired
    private ProcessInstanceDao processInstanceDao;

    public TaskGroupCoordinator() {
        super("TaskGroupCoordinator");
    }

    public synchronized void start() {
        log.info("TaskGroupCoordinator starting...");
        super.start();
        log.info("TaskGroupCoordinator started...");
    }

    public void run() {
        while (!ServerLifeCycleManager.isStopped()) {
            try {
                if (!ServerLifeCycleManager.isRunning()) continue;
                try {
                    this.registryClient.getLock(RegistryNodeType.MASTER_TASK_GROUP_COORDINATOR_LOCK.getRegistryPath());
                    StopWatch taskGroupCoordinatorRoundTimeCost = StopWatch.createStarted();
                    this.amendTaskGroupUseSize();
                    this.amendTaskGroupQueueStatus();
                    this.dealWithForceStartTaskGroupQueue();
                    this.dealWithWaitingTaskGroupQueue();
                    taskGroupCoordinatorRoundTimeCost.stop();
                    log.info("TaskGroupCoordinator round time cost: {}/ms", (Object)taskGroupCoordinatorRoundTimeCost.getTime());
                }
                finally {
                    this.registryClient.releaseLock(RegistryNodeType.MASTER_TASK_GROUP_COORDINATOR_LOCK.getRegistryPath());
                }
            }
            catch (Throwable e) {
                log.error("TaskGroupCoordinator error", e);
            }
            finally {
                ThreadUtils.sleep((long)5000L);
            }
        }
    }

    private void amendTaskGroupUseSize() {
        List taskGroups = this.taskGroupDao.queryAllTaskGroups();
        if (CollectionUtils.isEmpty((Collection)taskGroups)) {
            return;
        }
        for (TaskGroup taskGroup : taskGroups) {
            List taskGroupQueues = this.taskGroupQueueDao.queryAcquiredTaskGroupQueueByGroupId(taskGroup.getId());
            int actualUseSize = taskGroupQueues.size();
            if (taskGroup.getUseSize() == actualUseSize) continue;
            log.warn("The TaskGroup: {} useSize is {}, but the actual use size is {}, will amend it", new Object[]{taskGroup.getName(), taskGroup.getUseSize(), actualUseSize});
            taskGroup.setUseSize(actualUseSize);
            this.taskGroupDao.updateById((Object)taskGroup);
        }
    }

    private void amendTaskGroupQueueStatus() {
        List taskGroupQueues = this.taskGroupQueueDao.queryAllInQueueTaskGroupQueue();
        List taskInstanceIds = taskGroupQueues.stream().map(TaskGroupQueue::getTaskId).collect(Collectors.toList());
        Map taskInstanceMap = this.taskInstanceDao.queryByIds(taskInstanceIds).stream().collect(Collectors.toMap(TaskInstance::getId, Function.identity()));
        for (TaskGroupQueue taskGroupQueue : taskGroupQueues) {
            int taskId = taskGroupQueue.getTaskId();
            TaskInstance taskInstance = (TaskInstance)taskInstanceMap.get(taskId);
            if (taskInstance == null) {
                log.warn("The TaskInstance: {} is not exist, will release the TaskGroupQueue: {}", (Object)taskId, (Object)taskGroupQueue);
                this.releaseTaskGroupQueueSlot(taskGroupQueue);
                continue;
            }
            if (!taskInstance.getState().isFinished()) continue;
            log.warn("The TaskInstance: {} state: {} finished, will release the TaskGroupQueue: {}", new Object[]{taskInstance.getName(), taskInstance.getState(), taskGroupQueue});
            this.releaseTaskGroupQueueSlot(taskGroupQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealWithForceStartTaskGroupQueue() {
        List taskGroupQueues = this.taskGroupQueueDao.queryAllInQueueTaskGroupQueue().stream().filter(taskGroupQueue -> Flag.YES.getCode() == taskGroupQueue.getForceStart()).collect(Collectors.toList());
        for (TaskGroupQueue taskGroupQueue2 : taskGroupQueues) {
            try {
                LogUtils.setTaskInstanceIdMDC((Integer)taskGroupQueue2.getTaskId());
                this.notifyWaitingTaskInstance(taskGroupQueue2);
                log.info("Notify the ForceStart waiting TaskInstance: {} for taskGroupQueue: {} success", (Object)taskGroupQueue2.getTaskName(), (Object)taskGroupQueue2.getId());
                taskGroupQueue2.setInQueue(Flag.NO.getCode());
                taskGroupQueue2.setStatus(TaskGroupQueueStatus.RELEASE);
                taskGroupQueue2.setUpdateTime(new Date());
                this.taskGroupQueueDao.updateById((Object)taskGroupQueue2);
                log.info("Release the force start TaskGroupQueue {}", (Object)taskGroupQueue2);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.releaseTaskGroupQueueSlot(taskGroupQueue2);
                log.info("Notify the ForceStart TaskInstance: {} for taskGroupQueue: {} failed, will release the taskGroupQueue", new Object[]{taskGroupQueue2.getTaskName(), taskGroupQueue2.getId(), unsupportedOperationException});
            }
            catch (Throwable throwable) {
                log.info("Notify the force start TaskGroupQueue {} failed", (Object)taskGroupQueue2, (Object)throwable);
            }
            finally {
                LogUtils.removeTaskInstanceIdMDC();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealWithWaitingTaskGroupQueue() {
        List taskGroups = this.taskGroupDao.queryAvailableTaskGroups();
        if (CollectionUtils.isEmpty((Collection)taskGroups)) {
            log.debug("There is no available task group");
            return;
        }
        for (TaskGroup taskGroup : taskGroups) {
            int availableSize = taskGroup.getGroupSize() - taskGroup.getUseSize();
            if (availableSize <= 0) {
                log.info("TaskGroup {} is full, available size is {}", (Object)taskGroup, (Object)availableSize);
                continue;
            }
            List taskGroupQueues = this.taskGroupQueueDao.queryAllInQueueTaskGroupQueueByGroupId(taskGroup.getId()).stream().filter(taskGroupQueue -> Flag.NO.getCode() == taskGroupQueue.getForceStart()).filter(taskGroupQueue -> TaskGroupQueueStatus.WAIT_QUEUE == taskGroupQueue.getStatus()).limit(availableSize).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(taskGroupQueues)) {
                log.debug("There is no waiting task group queue for task group {}", (Object)taskGroup.getName());
                continue;
            }
            for (TaskGroupQueue taskGroupQueue2 : taskGroupQueues) {
                try {
                    LogUtils.setTaskInstanceIdMDC((Integer)taskGroupQueue2.getTaskId());
                    boolean acquireResult = this.taskGroupDao.acquireTaskGroupSlot(taskGroup.getId());
                    if (!acquireResult) {
                        log.error("Failed to acquire task group slot for task group {}", (Object)taskGroup);
                        continue;
                    }
                    this.notifyWaitingTaskInstance(taskGroupQueue2);
                    taskGroupQueue2.setInQueue(Flag.YES.getCode());
                    taskGroupQueue2.setStatus(TaskGroupQueueStatus.ACQUIRE_SUCCESS);
                    taskGroupQueue2.setUpdateTime(new Date());
                    this.taskGroupQueueDao.updateById((Object)taskGroupQueue2);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.releaseTaskGroupQueueSlot(taskGroupQueue2);
                    log.info("Notify the Waiting TaskInstance: {} for taskGroupQueue: {} failed, will release the taskGroupQueue", new Object[]{taskGroupQueue2.getTaskName(), taskGroupQueue2.getId(), unsupportedOperationException});
                }
                catch (Throwable throwable) {
                    log.error("Notify Waiting TaskGroupQueue: {} failed", (Object)taskGroupQueue2, (Object)throwable);
                }
                finally {
                    LogUtils.removeTaskInstanceIdMDC();
                }
            }
        }
    }

    public boolean needAcquireTaskGroupSlot(TaskInstance taskInstance) {
        if (taskInstance == null) {
            throw new IllegalArgumentException("The TaskInstance is null");
        }
        if (taskInstance.getTaskGroupId() <= 0) {
            log.debug("The current TaskInstance doesn't use TaskGroup, no need to acquire TaskGroupSlot");
            return false;
        }
        TaskGroup taskGroup = (TaskGroup)this.taskGroupDao.queryById((Serializable)Integer.valueOf(taskInstance.getTaskGroupId()));
        if (taskGroup == null) {
            log.warn("The current TaskGroup: {} does not exist, will not acquire TaskGroupSlot", (Object)taskInstance.getTaskGroupId());
            return false;
        }
        return Flag.YES.equals((Object)taskGroup.getStatus());
    }

    public void acquireTaskGroupSlot(TaskInstance taskInstance) {
        if (taskInstance == null || taskInstance.getTaskGroupId() <= 0) {
            throw new IllegalArgumentException("The current TaskInstance does not use task group");
        }
        TaskGroup taskGroup = (TaskGroup)this.taskGroupDao.queryById((Serializable)Integer.valueOf(taskInstance.getTaskGroupId()));
        if (taskGroup == null) {
            throw new IllegalArgumentException("The current TaskGroup: " + taskInstance.getTaskGroupId() + " does not exist");
        }
        Date now = new Date();
        TaskGroupQueue taskGroupQueue = TaskGroupQueue.builder().taskId(taskInstance.getId().intValue()).taskName(taskInstance.getName()).groupId(taskInstance.getTaskGroupId()).processId(taskInstance.getProcessInstanceId()).priority(taskInstance.getTaskGroupPriority()).inQueue(Flag.YES.getCode()).forceStart(Flag.NO.getCode()).status(TaskGroupQueueStatus.WAIT_QUEUE).createTime(now).updateTime(now).build();
        log.info("Success insert TaskGroupQueue: {} for TaskInstance: {}", (Object)taskGroupQueue, (Object)taskInstance.getName());
        this.taskGroupQueueDao.insert((Object)taskGroupQueue);
    }

    public boolean needToReleaseTaskGroupSlot(TaskInstance taskInstance) {
        if (taskInstance == null) {
            throw new IllegalArgumentException("The TaskInstance is null");
        }
        if (taskInstance.getTaskGroupId() <= 0) {
            log.debug("The current TaskInstance doesn't use TaskGroup, no need to release TaskGroupSlot");
            return false;
        }
        return true;
    }

    public void releaseTaskGroupSlot(TaskInstance taskInstance) {
        if (taskInstance == null || taskInstance.getTaskGroupId() <= 0) {
            throw new IllegalArgumentException("The current TaskInstance does not use task group");
        }
        List taskGroupQueues = this.taskGroupQueueDao.queryByTaskInstanceId(taskInstance.getId());
        for (TaskGroupQueue taskGroupQueue : taskGroupQueues) {
            this.releaseTaskGroupQueueSlot(taskGroupQueue);
        }
    }

    private void notifyWaitingTaskInstance(TaskGroupQueue taskGroupQueue) {
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceDao.queryById((Serializable)Integer.valueOf(taskGroupQueue.getTaskId()));
        if (taskInstance == null) {
            throw new UnsupportedOperationException("The TaskInstance: " + taskGroupQueue.getTaskId() + " is not exist, no need to notify");
        }
        if (taskInstance.getState() != TaskExecutionStatus.SUBMITTED_SUCCESS) {
            throw new UnsupportedOperationException("The TaskInstance: " + taskInstance.getId() + " state is " + taskInstance.getState() + ", no need to notify");
        }
        ProcessInstance processInstance = (ProcessInstance)this.processInstanceDao.queryById((Serializable)Integer.valueOf(taskInstance.getProcessInstanceId()));
        if (processInstance == null) {
            throw new UnsupportedOperationException("The WorkflowInstance: " + taskInstance.getProcessInstanceId() + " is not exist, no need to notify");
        }
        if (processInstance.getState() != WorkflowExecutionStatus.RUNNING_EXECUTION) {
            throw new UnsupportedOperationException("The WorkflowInstance: " + processInstance.getId() + " state is " + processInstance.getState() + ", no need to notify");
        }
        if (processInstance.getHost() == null || "NULL".equals(processInstance.getHost())) {
            throw new UnsupportedOperationException("WorkflowInstance host is null, maybe it is in failover: " + processInstance);
        }
        TaskInstanceWakeupRequest taskInstanceWakeupRequest = TaskInstanceWakeupRequest.builder().processInstanceId(processInstance.getId().intValue()).taskInstanceId(taskInstance.getId().intValue()).build();
        IWorkflowInstanceService iWorkflowInstanceService = (IWorkflowInstanceService)SingletonJdkDynamicRpcClientProxyFactory.getProxyClient((String)processInstance.getHost(), IWorkflowInstanceService.class);
        TaskInstanceWakeupResponse taskInstanceWakeupResponse = iWorkflowInstanceService.wakeupTaskInstance(taskInstanceWakeupRequest);
        if (!taskInstanceWakeupResponse.isSuccess()) {
            throw new UnsupportedOperationException("Notify TaskInstance: " + taskInstance.getId() + " failed: " + taskInstanceWakeupResponse);
        }
        log.info("Wake up TaskInstance: {} success", (Object)taskInstance.getName());
    }

    private void releaseTaskGroupQueueSlot(TaskGroupQueue taskGroupQueue) {
        if (TaskGroupQueueStatus.RELEASE.equals((Object)taskGroupQueue.getStatus()) && Flag.NO.getCode() == taskGroupQueue.getInQueue()) {
            log.info("The TaskGroupQueue: {} is already released", (Object)taskGroupQueue);
            return;
        }
        taskGroupQueue.setInQueue(Flag.NO.getCode());
        taskGroupQueue.setStatus(TaskGroupQueueStatus.RELEASE);
        taskGroupQueue.setUpdateTime(new Date());
        this.taskGroupQueueDao.updateById((Object)taskGroupQueue);
        log.info("Success release TaskGroupQueue: {}", (Object)taskGroupQueue);
    }
}

