/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.service;

import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.apache.dolphinscheduler.server.master.service.MasterFailoverService;
import org.apache.dolphinscheduler.server.master.service.WorkerFailoverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FailoverService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FailoverService.class);
    private final MasterFailoverService masterFailoverService;
    private final WorkerFailoverService workerFailoverService;

    public FailoverService(@NonNull MasterFailoverService masterFailoverService, @NonNull WorkerFailoverService workerFailoverService) {
        if (masterFailoverService == null) {
            throw new NullPointerException("masterFailoverService is marked non-null but is null");
        }
        if (workerFailoverService == null) {
            throw new NullPointerException("workerFailoverService is marked non-null but is null");
        }
        this.masterFailoverService = masterFailoverService;
        this.workerFailoverService = workerFailoverService;
    }

    public void failoverServerWhenDown(String serverHost, RegistryNodeType nodeType) {
        switch (nodeType) {
            case MASTER: {
                log.info("Master failover starting, masterServer: {}", (Object)serverHost);
                this.masterFailoverService.failoverMaster(serverHost);
                log.info("Master failover finished, masterServer: {}", (Object)serverHost);
                break;
            }
            case WORKER: {
                log.info("Worker failover starting, workerServer: {}", (Object)serverHost);
                this.workerFailoverService.failoverWorker(serverHost);
                log.info("Worker failover finished, workerServer: {}", (Object)serverHost);
                break;
            }
        }
    }
}

