/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.task;

import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.common.enums.ServerStatus;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.model.BaseHeartBeatTask;
import org.apache.dolphinscheduler.common.model.MasterHeartBeat;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.meter.metrics.MetricsProvider;
import org.apache.dolphinscheduler.meter.metrics.SystemMetrics;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.config.MasterServerLoadProtection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterHeartBeatTask
extends BaseHeartBeatTask<MasterHeartBeat> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterHeartBeatTask.class);
    private final MasterConfig masterConfig;
    private final MetricsProvider metricsProvider;
    private final RegistryClient registryClient;
    private final String heartBeatPath;
    private final int processId;

    public MasterHeartBeatTask(@NonNull MasterConfig masterConfig, @NonNull MetricsProvider metricsProvider, @NonNull RegistryClient registryClient) {
        super("MasterHeartBeatTask", masterConfig.getMaxHeartbeatInterval().toMillis());
        if (masterConfig == null) {
            throw new NullPointerException("masterConfig is marked non-null but is null");
        }
        if (metricsProvider == null) {
            throw new NullPointerException("metricsProvider is marked non-null but is null");
        }
        if (registryClient == null) {
            throw new NullPointerException("registryClient is marked non-null but is null");
        }
        this.masterConfig = masterConfig;
        this.metricsProvider = metricsProvider;
        this.registryClient = registryClient;
        this.heartBeatPath = masterConfig.getMasterRegistryPath();
        this.processId = OSUtils.getProcessID();
    }

    public MasterHeartBeat getHeartBeat() {
        SystemMetrics systemMetrics = this.metricsProvider.getSystemMetrics();
        ServerStatus serverStatus = this.getServerStatus(systemMetrics, this.masterConfig.getServerLoadProtection());
        return MasterHeartBeat.builder().startupTime(ServerLifeCycleManager.getServerStartupTime()).reportTime(System.currentTimeMillis()).cpuUsage(systemMetrics.getTotalCpuUsedPercentage()).jvmMemoryUsage(systemMetrics.getJvmMemoryUsedPercentage()).memoryUsage(systemMetrics.getSystemMemoryUsedPercentage()).diskUsage(systemMetrics.getDiskUsedPercentage()).processId(this.processId).serverStatus(serverStatus).host(NetUtils.getHost()).port(this.masterConfig.getListenPort()).build();
    }

    public void writeHeartBeat(MasterHeartBeat masterHeartBeat) {
        String masterHeartBeatJson = JSONUtils.toJsonString((Object)masterHeartBeat);
        this.registryClient.persistEphemeral(this.heartBeatPath, masterHeartBeatJson);
        log.debug("Success write master heartBeatInfo into registry, masterRegistryPath: {}, heartBeatInfo: {}", (Object)this.heartBeatPath, (Object)masterHeartBeatJson);
    }

    private ServerStatus getServerStatus(SystemMetrics systemMetrics, MasterServerLoadProtection masterServerLoadProtection) {
        return masterServerLoadProtection.isOverload(systemMetrics) ? ServerStatus.BUSY : ServerStatus.NORMAL;
    }
}

