/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.utils;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.TaskExecuteType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceDao;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionDao;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionLogDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependResult;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependentRelation;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.DateInterval;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentItem;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parameters.DependentParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.DependentUtils;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependentExecute {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DependentExecute.class);
    private final ProcessInstanceDao processInstanceDao = (ProcessInstanceDao)SpringApplicationContext.getBean(ProcessInstanceDao.class);
    private final TaskInstanceDao taskInstanceDao = (TaskInstanceDao)SpringApplicationContext.getBean(TaskInstanceDao.class);
    private List<DependentItem> dependItemList;
    private DependentRelation relation;
    private ProcessInstance processInstance;
    private TaskInstance taskInstance;
    private Map<String, DependResult> dependResultMap = new HashMap<String, DependResult>();
    private final ProcessService processService = (ProcessService)SpringApplicationContext.getBean(ProcessService.class);
    private final TaskDefinitionLogDao taskDefinitionLogDao = (TaskDefinitionLogDao)SpringApplicationContext.getBean(TaskDefinitionLogDao.class);
    private final TaskDefinitionDao taskDefinitionDao = (TaskDefinitionDao)SpringApplicationContext.getBean(TaskDefinitionDao.class);
    private Map<String, Property> dependTaskVarPoolPropertyMap = new HashMap<String, Property>();
    private Map<String, Long> dependTaskVarPoolEndTimeMap = new HashMap<String, Long>();
    private Map<String, Property> dependItemVarPoolPropertyMap = new HashMap<String, Property>();
    private Map<String, Long> dependItemVarPoolEndTimeMap = new HashMap<String, Long>();

    public DependentExecute(List<DependentItem> itemList, DependentRelation relation, ProcessInstance processInstance, TaskInstance taskInstance) {
        this.dependItemList = itemList;
        this.relation = relation;
        this.processInstance = processInstance;
        this.taskInstance = taskInstance;
    }

    private DependResult getDependentResultForItem(DependentItem dependentItem, Date currentTime, int testFlag) {
        List dateIntervals = DependentUtils.getDateIntervalList((Date)currentTime, (String)dependentItem.getDateValue());
        return this.calculateResultForTasks(dependentItem, dateIntervals, testFlag);
    }

    private DependResult calculateResultForTasks(DependentItem dependentItem, List<DateInterval> dateIntervals, int testFlag) {
        DependResult result = DependResult.FAILED;
        for (DateInterval dateInterval : dateIntervals) {
            ProcessInstance processInstance = this.findLastProcessInterval(dependentItem.getDefinitionCode(), dateInterval, testFlag);
            if (processInstance == null) {
                return DependResult.WAITING;
            }
            result = dependentItem.getDepTaskCode() == 0L ? this.dependResultByProcessInstance(processInstance) : (dependentItem.getDepTaskCode() == -1L ? this.dependResultByAllTaskOfProcessInstance(processInstance, testFlag) : this.dependResultBySingleTaskInstance(processInstance, dependentItem.getDepTaskCode(), testFlag));
            if (result == DependResult.SUCCESS) continue;
            break;
        }
        return result;
    }

    private DependResult dependResultByProcessInstance(ProcessInstance processInstance) {
        if (!processInstance.getState().isFinished()) {
            return DependResult.WAITING;
        }
        if (processInstance.getState().isSuccess()) {
            this.addItemVarPool(processInstance.getVarPool(), processInstance.getEndTime().getTime());
            return DependResult.SUCCESS;
        }
        log.warn("The dependent workflow did not execute successfully, so return depend failed. processCode: {}, processName: {}", (Object)processInstance.getProcessDefinitionCode(), (Object)processInstance.getName());
        return DependResult.FAILED;
    }

    private DependResult dependResultByAllTaskOfProcessInstance(ProcessInstance processInstance, int testFlag) {
        if (!processInstance.getState().isFinished()) {
            log.info("Wait for the dependent workflow to complete, processCode: {}, processInstanceId: {}.", (Object)processInstance.getProcessDefinitionCode(), (Object)processInstance.getId());
            return DependResult.WAITING;
        }
        if (processInstance.getState().isSuccess()) {
            List processTaskRelations = this.processService.findRelationByCode(processInstance.getProcessDefinitionCode().longValue(), processInstance.getProcessDefinitionVersion());
            List taskDefinitionLogs = this.taskDefinitionLogDao.queryTaskDefineLogList(processTaskRelations);
            Map<Long, String> taskDefinitionCodeMap = taskDefinitionLogs.stream().filter(taskDefinitionLog -> taskDefinitionLog.getFlag() == Flag.YES).collect(Collectors.toMap(TaskDefinition::getCode, TaskDefinition::getName));
            List taskInstanceList = this.taskInstanceDao.queryLastTaskInstanceListIntervalInProcessInstance(processInstance.getId(), taskDefinitionCodeMap.keySet(), testFlag);
            Map<Long, TaskExecutionStatus> taskExecutionStatusMap = taskInstanceList.stream().filter(taskInstance -> taskInstance.getTaskExecuteType() != TaskExecuteType.STREAM).collect(Collectors.toMap(TaskInstance::getTaskCode, TaskInstance::getState));
            for (Long taskCode : taskDefinitionCodeMap.keySet()) {
                if (!taskExecutionStatusMap.containsKey(taskCode)) {
                    log.warn("The task of the workflow is not being executed, taskCode: {}, processInstanceId: {}, processName: {}.", new Object[]{taskCode, processInstance.getProcessDefinitionCode(), processInstance.getName()});
                    return DependResult.FAILED;
                }
                if (taskExecutionStatusMap.get(taskCode).isSuccess()) continue;
                log.warn("The task of the workflow is not being executed successfully, taskCode: {}, processInstanceId: {}, processName: {}.", new Object[]{taskCode, processInstance.getProcessDefinitionCode(), processInstance.getName()});
                return DependResult.FAILED;
            }
            this.addItemVarPool(processInstance.getVarPool(), processInstance.getEndTime().getTime());
            return DependResult.SUCCESS;
        }
        return DependResult.FAILED;
    }

    private DependResult dependResultBySingleTaskInstance(ProcessInstance processInstance, long depTaskCode, int testFlag) {
        TaskInstance taskInstance = this.taskInstanceDao.queryLastTaskInstanceIntervalInProcessInstance(processInstance.getId(), depTaskCode, testFlag);
        if (taskInstance == null) {
            TaskDefinition taskDefinition = this.taskDefinitionDao.queryByCode(depTaskCode);
            if (taskDefinition == null) {
                log.error("The dependent task definition can not be find, so return depend failed, taskCode: {}", (Object)depTaskCode);
                return DependResult.FAILED;
            }
            if (taskDefinition.getFlag() == Flag.NO) {
                log.info("The dependent task is a forbidden task, so return depend success. Task code: {}, task name: {}", (Object)taskDefinition.getCode(), (Object)taskDefinition.getName());
                return DependResult.SUCCESS;
            }
            if (!processInstance.getState().isFinished()) {
                log.info("Wait for the dependent workflow to complete, processCode: {}, processInstanceId: {}.", (Object)processInstance.getProcessDefinitionCode(), (Object)processInstance.getId());
                return DependResult.WAITING;
            }
            return DependResult.FAILED;
        }
        if (TaskExecuteType.STREAM == taskInstance.getTaskExecuteType()) {
            log.info("The dependent task is a streaming task, so return depend success. Task code: {}, task name: {}.", (Object)taskInstance.getTaskCode(), (Object)taskInstance.getName());
            this.addItemVarPool(taskInstance.getVarPool(), taskInstance.getEndTime().getTime());
            return DependResult.SUCCESS;
        }
        return this.getDependResultByState(taskInstance.getState());
    }

    private void addItemVarPool(String varPoolStr, Long endTime) {
        ArrayList varPool = new ArrayList(JSONUtils.toList((String)varPoolStr, Property.class));
        if (!varPool.isEmpty()) {
            Map varPoolPropertyMap = varPool.stream().filter(p -> p.getDirect().equals((Object)Direct.OUT)).collect(Collectors.toMap(Property::getProp, Function.identity()));
            Map<String, Long> varPoolEndTimeMap = varPool.stream().filter(p -> p.getDirect().equals((Object)Direct.OUT)).collect(Collectors.toMap(Property::getProp, d -> endTime));
            this.dependItemVarPoolPropertyMap.putAll(varPoolPropertyMap);
            this.dependItemVarPoolEndTimeMap.putAll(varPoolEndTimeMap);
        }
    }

    private ProcessInstance findLastProcessInterval(Long definitionCode, DateInterval dateInterval, int testFlag) {
        ProcessInstance lastSchedulerProcess = this.processInstanceDao.queryLastSchedulerProcessInterval(definitionCode, dateInterval, testFlag);
        ProcessInstance lastManualProcess = this.processInstanceDao.queryLastManualProcessInterval(definitionCode, dateInterval, testFlag);
        if (lastManualProcess == null) {
            return lastSchedulerProcess;
        }
        if (lastSchedulerProcess == null) {
            return lastManualProcess;
        }
        return lastManualProcess.getId() > lastSchedulerProcess.getId() ? lastManualProcess : lastSchedulerProcess;
    }

    private DependResult getDependResultByState(TaskExecutionStatus state) {
        if (!state.isFinished()) {
            return DependResult.WAITING;
        }
        if (state.isSuccess()) {
            return DependResult.SUCCESS;
        }
        log.warn("The dependent task were not executed successfully, so return depend failed. Task code: {}, task name: {}.", (Object)this.taskInstance.getTaskCode(), (Object)this.taskInstance.getName());
        return DependResult.FAILED;
    }

    public boolean finish(Date currentTime, int testFlag, DependentParameters.DependentFailurePolicyEnum failurePolicy, Integer failureWaitingTime) {
        DependResult modelDependResult = this.getModelDependResult(currentTime, testFlag);
        if (modelDependResult == DependResult.WAITING) {
            return false;
        }
        if (modelDependResult == DependResult.FAILED && DependentParameters.DependentFailurePolicyEnum.DEPENDENT_FAILURE_WAITING == failurePolicy && failureWaitingTime != null) {
            return Duration.between(currentTime.toInstant(), Instant.now()).compareTo(Duration.ofMinutes(failureWaitingTime.intValue())) > 0;
        }
        return true;
    }

    public DependResult getModelDependResult(Date currentTime, int testFlag) {
        ArrayList<DependResult> dependResultList = new ArrayList<DependResult>();
        for (DependentItem dependentItem : this.dependItemList) {
            if (this.isSelfDependent(dependentItem) && this.isFirstProcessInstance(dependentItem)) {
                this.dependResultMap.put(dependentItem.getKey(), DependResult.SUCCESS);
                dependResultList.add(DependResult.SUCCESS);
                log.info("This dependent item is self-dependent and run at first time, default success, processDefinitionCode:{}, depTaskCode:{}", (Object)dependentItem.getDefinitionCode(), (Object)dependentItem.getDepTaskCode());
                continue;
            }
            DependResult dependResult = this.getDependResultForItem(dependentItem, currentTime, testFlag);
            if (dependResult != DependResult.WAITING && dependResult != DependResult.FAILED) {
                this.dependResultMap.put(dependentItem.getKey(), dependResult);
                if (dependentItem.getParameterPassing().booleanValue() && !this.dependItemVarPoolPropertyMap.isEmpty()) {
                    DependentUtils.addTaskVarPool(this.dependItemVarPoolPropertyMap, this.dependItemVarPoolEndTimeMap, this.dependTaskVarPoolPropertyMap, this.dependTaskVarPoolEndTimeMap);
                }
            }
            this.dependItemVarPoolPropertyMap.clear();
            this.dependItemVarPoolEndTimeMap.clear();
            dependResultList.add(dependResult);
        }
        return DependentUtils.getDependResultForRelation((DependentRelation)this.relation, dependResultList);
    }

    private DependResult getDependResultForItem(DependentItem item, Date currentTime, int testFlag) {
        String key = item.getKey();
        if (this.dependResultMap.containsKey(key)) {
            return this.dependResultMap.get(key);
        }
        return this.getDependentResultForItem(item, currentTime, testFlag);
    }

    public Map<String, DependResult> getDependResultMap() {
        return this.dependResultMap;
    }

    public Map<String, Property> getDependTaskVarPoolPropertyMap() {
        return this.dependTaskVarPoolPropertyMap;
    }

    public Map<String, Long> getDependTaskVarPoolEndTimeMap() {
        return this.dependTaskVarPoolEndTimeMap;
    }

    public boolean isSelfDependent(DependentItem dependentItem) {
        if (this.processInstance.getProcessDefinitionCode().equals(dependentItem.getDefinitionCode())) {
            if (dependentItem.getDepTaskCode() == -1L) {
                return true;
            }
            if (dependentItem.getDepTaskCode() == this.taskInstance.getTaskCode()) {
                return true;
            }
        }
        return false;
    }

    public boolean isFirstProcessInstance(DependentItem dependentItem) {
        ProcessInstance firstProcessInstance = this.processInstanceDao.queryFirstScheduleProcessInstance(Long.valueOf(dependentItem.getDefinitionCode()));
        if (firstProcessInstance == null && (firstProcessInstance = this.processInstanceDao.queryFirstStartProcessInstance(Long.valueOf(dependentItem.getDefinitionCode()))) == null) {
            log.warn("First process instance is null, processDefinitionCode:{}", (Object)dependentItem.getDefinitionCode());
            return false;
        }
        return firstProcessInstance.getId() == this.processInstance.getId();
    }
}

