/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.utils;

import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;

public final class WorkflowInstanceUtils {
    public static String logWorkflowInstanceInDetails(ProcessInstance workflowInstance) {
        StringBuilder logBuilder = new StringBuilder();
        int horizontalLineLength = 80;
        int titleLength = 40;
        int leftSpaces = (horizontalLineLength - titleLength) / 2;
        String centeredTitle = String.format("%" + leftSpaces + "s%s", "", "Workflow Instance Detail");
        logBuilder.append("\n").append(Strings.repeat((String)"*", (int)horizontalLineLength)).append("\n").append(centeredTitle).append("\n").append(Strings.repeat((String)"*", (int)horizontalLineLength)).append("\n").append("Workflow Name:             ").append(workflowInstance.getProcessDefinition().getName()).append("\n").append("Workflow Instance Name:    ").append(workflowInstance.getName()).append("\n").append("Command Type:              ").append(workflowInstance.getCommandType()).append("\n").append("State:                     ").append(workflowInstance.getState().getDesc()).append("\n").append("Host:                      ").append(workflowInstance.getHost()).append("\n").append("Is Sub Process:            ").append(workflowInstance.getIsSubProcess().getDescp()).append("\n").append("Run Times:                 ").append(workflowInstance.getRunTimes()).append("\n").append("Max Try Times:             ").append(workflowInstance.getMaxTryTimes()).append("\n").append("Schedule Time:             ").append(workflowInstance.getScheduleTime()).append("\n").append("Dry Run:                   ").append(workflowInstance.getDryRun()).append("\n").append("Tenant:                    ").append(workflowInstance.getTenantCode()).append("\n").append("Restart Time:              ").append(workflowInstance.getRestartTime()).append("\n").append("Work Group:                ").append(workflowInstance.getWorkerGroup()).append("\n").append("Start Time:                ").append(workflowInstance.getStartTime()).append("\n").append("End Time:                  ").append(workflowInstance.getEndTime()).append("\n");
        return logBuilder.toString();
    }

    public static String logTaskInstanceInDetail(TaskInstance taskInstance) {
        StringBuilder logBuilder = new StringBuilder();
        int horizontalLineLength = 80;
        int titleLength = 40;
        int leftSpaces = (horizontalLineLength - titleLength) / 2;
        String centeredTitle = String.format("%" + leftSpaces + "s%s", "", "Task Instance Detail");
        logBuilder.append("\n").append(Strings.repeat((String)"*", (int)horizontalLineLength)).append("\n").append(centeredTitle).append("\n").append(Strings.repeat((String)"*", (int)horizontalLineLength)).append("\n").append("Task Name:              ").append(taskInstance.getName()).append("\n").append("Workflow Instance Name: ").append(taskInstance.getProcessInstance().getName()).append("\n").append("Task Execute Type:      ").append(taskInstance.getTaskExecuteType().getDesc()).append("\n").append("Execute State:          ").append(taskInstance.getState().getDesc()).append("\n").append("Host:                   ").append(taskInstance.getHost()).append("\n").append("Task Type:              ").append(taskInstance.getTaskType()).append("\n").append("Priority:               ").append(taskInstance.getTaskInstancePriority().getDescp()).append("\n").append("Tenant:                 ").append(taskInstance.getProcessInstance().getTenantCode()).append("\n").append("First Submit Time:      ").append(taskInstance.getFirstSubmitTime()).append("\n").append("Submit Time:            ").append(taskInstance.getSubmitTime()).append("\n").append("Start Time:             ").append(taskInstance.getStartTime()).append("\n").append("End Time:               ").append(taskInstance.getEndTime()).append("\n");
        return logBuilder.toString();
    }

    @Generated
    private WorkflowInstanceUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

