/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.thread.ThreadPoolExecutors;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.dao.ProcessDao;
import org.apache.dolphinscheduler.server.master.AbstractServer;
import org.apache.dolphinscheduler.server.master.runner.MasterSchedulerThread;
import org.apache.dolphinscheduler.server.quartz.ProcessScheduleJob;
import org.apache.dolphinscheduler.server.quartz.QuartzExecutors;
import org.apache.dolphinscheduler.server.zk.ZKMasterClient;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.context.annotation.ComponentScan;

@ComponentScan(value={"org.apache.dolphinscheduler"})
public class MasterServer
extends AbstractServer {
    private static final Logger logger = LoggerFactory.getLogger(MasterServer.class);
    private ZKMasterClient zkMasterClient = null;
    private ScheduledExecutorService heartbeatMasterService;
    @Autowired
    protected ProcessDao processDao;
    private ExecutorService masterSchedulerService;

    public static void main(String[] args) {
        SpringApplication.run(MasterServer.class, (String[])args);
    }

    @PostConstruct
    public void run() {
        try {
            conf = new PropertiesConfiguration("master.properties");
        }
        catch (ConfigurationException e) {
            logger.error("load configuration failed : " + e.getMessage(), (Throwable)e);
            System.exit(1);
        }
        this.masterSchedulerService = ThreadUtils.newDaemonSingleThreadExecutor((String)"Master-Scheduler-Thread");
        this.zkMasterClient = ZKMasterClient.getZKMasterClient(this.processDao);
        this.heartBeatInterval = conf.getInt("master.heartbeat.interval", 60);
        int masterExecThreadNum = conf.getInt("master.exec.threads", 100);
        this.heartbeatMasterService = ThreadUtils.newDaemonThreadScheduledExecutor((String)"Master-Main-Thread", (int)1);
        Runnable heartBeatThread = this.heartBeatThread();
        this.zkMasterClient.setStoppable(this);
        this.heartbeatMasterService.scheduleAtFixedRate(heartBeatThread, 5L, this.heartBeatInterval, TimeUnit.SECONDS);
        MasterSchedulerThread masterSchedulerThread = new MasterSchedulerThread(this.zkMasterClient, this.processDao, conf, masterExecThreadNum);
        this.masterSchedulerService.execute(masterSchedulerThread);
        try {
            ProcessScheduleJob.init(this.processDao);
            QuartzExecutors.getInstance().start();
        }
        catch (Exception e) {
            try {
                QuartzExecutors.getInstance().shutdown();
            }
            catch (SchedulerException e1) {
                logger.error("QuartzExecutors shutdown failed : " + e1.getMessage(), (Throwable)e1);
            }
            logger.error("start Quartz failed : " + e.getMessage(), (Throwable)e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (MasterServer.this.zkMasterClient.getActiveMasterNum() <= 1) {
                    for (int i = 0; i < 3; ++i) {
                        MasterServer.this.zkMasterClient.getAlertDao().sendServerStopedAlert(1, OSUtils.getHost(), "Master-Server");
                    }
                }
                MasterServer.this.stop("shutdownhook");
            }
        }));
    }

    @Override
    public synchronized void stop(String cause) {
        try {
            if (Stopper.isStoped()) {
                return;
            }
            logger.info("master server is stopping ..., cause : {}", (Object)cause);
            Stopper.stop();
            try {
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                logger.warn("thread sleep exception:" + e.getMessage(), (Throwable)e);
            }
            try {
                this.heartbeatMasterService.shutdownNow();
            }
            catch (Exception e) {
                logger.warn("heartbeat service stopped exception");
            }
            logger.info("heartbeat service stopped");
            try {
                QuartzExecutors.getInstance().shutdown();
            }
            catch (Exception e) {
                logger.warn("Quartz service stopped exception:{}", (Object)e.getMessage());
            }
            logger.info("Quartz service stopped");
            try {
                ThreadPoolExecutors.getInstance().shutdown();
            }
            catch (Exception e) {
                logger.warn("threadpool service stopped exception:{}", (Object)e.getMessage());
            }
            logger.info("threadpool service stopped");
            try {
                this.masterSchedulerService.shutdownNow();
            }
            catch (Exception e) {
                logger.warn("master scheduler service stopped exception:{}", (Object)e.getMessage());
            }
            logger.info("master scheduler service stopped");
            try {
                this.zkMasterClient.close();
            }
            catch (Exception e) {
                logger.warn("zookeeper service stopped exception:{}", (Object)e.getMessage());
            }
            logger.info("zookeeper service stopped");
        }
        catch (Exception e) {
            logger.error("master server stop exception : " + e.getMessage(), (Throwable)e);
            System.exit(-1);
        }
    }

    private Runnable heartBeatThread() {
        Runnable heartBeatThread = new Runnable(){

            @Override
            public void run() {
                if (Stopper.isRunning()) {
                    if (StringUtils.isBlank((CharSequence)MasterServer.this.zkMasterClient.getMasterZNode())) {
                        logger.error("master send heartbeat to zk failed: can't find zookeeper path of master server");
                        return;
                    }
                    MasterServer.this.zkMasterClient.heartBeatForZk(MasterServer.this.zkMasterClient.getMasterZNode(), "master");
                }
            }
        };
        return heartBeatThread;
    }
}

