/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.concurrent.Callable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.dolphinscheduler.common.queue.ITaskQueue;
import org.apache.dolphinscheduler.common.queue.TaskQueueFactory;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.dao.ProcessDao;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.utils.BeanContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterBaseTaskExecThread
implements Callable<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger(MasterBaseTaskExecThread.class);
    protected ProcessDao processDao = (ProcessDao)BeanContext.getBean(ProcessDao.class);
    protected AlertDao alertDao = (AlertDao)BeanContext.getBean(AlertDao.class);
    protected ProcessInstance processInstance;
    protected TaskInstance taskInstance;
    protected ITaskQueue taskQueue;
    protected boolean cancel;
    private static Configuration conf;

    public MasterBaseTaskExecThread(TaskInstance taskInstance, ProcessInstance processInstance) {
        this.processInstance = processInstance;
        this.taskQueue = TaskQueueFactory.getTaskQueueInstance();
        this.cancel = false;
        this.taskInstance = taskInstance;
    }

    public TaskInstance getTaskInstance() {
        return this.taskInstance;
    }

    public void kill() {
        this.cancel = true;
    }

    protected TaskInstance submit() {
        Integer commitRetryTimes = conf.getInt("master.task.commit.retryTimes", 5);
        Integer commitRetryInterval = conf.getInt("master.task.commit.interval", 100);
        for (int retryTimes = 1; retryTimes <= commitRetryTimes; ++retryTimes) {
            try {
                TaskInstance task = this.processDao.submitTask(this.taskInstance, this.processInstance);
                if (task != null) {
                    return task;
                }
                logger.error("task commit to mysql and queue failed , task has already retry {} times, please check the database", (Object)commitRetryTimes);
                Thread.sleep(commitRetryInterval.intValue());
                continue;
            }
            catch (Exception e) {
                logger.error("task commit to mysql and queue failed : " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected Boolean submitWaitComplete() {
        return true;
    }

    @Override
    public Boolean call() throws Exception {
        return this.submitWaitComplete();
    }

    static {
        try {
            conf = new PropertiesConfiguration("master.properties");
        }
        catch (ConfigurationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }
}

