/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.dolphinscheduler.common.enums.AlertType;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.ShowType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.dao.DaoFactory;
import org.apache.dolphinscheduler.dao.entity.Alert;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertManager {
    private static final Logger logger = LoggerFactory.getLogger(AlertManager.class);
    private AlertDao alertDao = (AlertDao)DaoFactory.getDaoInstance(AlertDao.class);
    private static final String PROCESS_INSTANCE_FORMAT = "\"Id:%d\",\"Name:%s\",\"Job type: %s\",\"State: %s\",\"Recovery:%s\",\"Run time: %d\",\"Start time: %s\",\"End time: %s\",\"Host: %s\"";

    private String getCommandCnName(CommandType commandType) {
        switch (commandType) {
            case RECOVER_TOLERANCE_FAULT_PROCESS: {
                return "recover tolerance fault process";
            }
            case RECOVER_SUSPENDED_PROCESS: {
                return "recover suspended process";
            }
            case START_CURRENT_TASK_PROCESS: {
                return "start current task process";
            }
            case START_FAILURE_TASK_PROCESS: {
                return "start failure task process";
            }
            case START_PROCESS: {
                return "start process";
            }
            case REPEAT_RUNNING: {
                return "repeat running";
            }
            case SCHEDULER: {
                return "scheduler";
            }
            case COMPLEMENT_DATA: {
                return "complement data";
            }
            case PAUSE: {
                return "pause";
            }
            case STOP: {
                return "stop";
            }
        }
        return "unknown type";
    }

    public String getContentProcessInstance(ProcessInstance processInstance, List<TaskInstance> taskInstances) {
        String res = "";
        if (processInstance.getState().typeIsSuccess()) {
            res = String.format(PROCESS_INSTANCE_FORMAT, processInstance.getId(), processInstance.getName(), this.getCommandCnName(processInstance.getCommandType()), processInstance.getState().toString(), processInstance.getRecovery().toString(), processInstance.getRunTimes(), DateUtils.dateToString((Date)processInstance.getStartTime()), DateUtils.dateToString((Date)processInstance.getEndTime()), processInstance.getHost());
            res = "[" + res + "]";
        } else if (processInstance.getState().typeIsFailure()) {
            ArrayList failedTaskList = new ArrayList();
            for (TaskInstance task : taskInstances) {
                if (task.getState().typeIsSuccess()) continue;
                LinkedHashMap<String, String> failedTaskMap = new LinkedHashMap<String, String>();
                failedTaskMap.put("task id", String.valueOf(task.getId()));
                failedTaskMap.put("task name", task.getName());
                failedTaskMap.put("task type", task.getTaskType());
                failedTaskMap.put("task state", task.getState().toString());
                failedTaskMap.put("task start time", DateUtils.dateToString((Date)task.getStartTime()));
                failedTaskMap.put("task end time", DateUtils.dateToString((Date)task.getEndTime()));
                failedTaskMap.put("host", task.getHost());
                failedTaskMap.put("log path", task.getLogPath());
                failedTaskList.add(failedTaskMap);
            }
            res = JSONUtils.toJson(failedTaskList);
        }
        return res;
    }

    private String getWorkerToleranceContent(ProcessInstance processInstance, List<TaskInstance> toleranceTaskList) {
        ArrayList toleranceTaskInstanceList = new ArrayList();
        for (TaskInstance taskInstance : toleranceTaskList) {
            LinkedHashMap<String, String> toleranceWorkerContentMap = new LinkedHashMap<String, String>();
            toleranceWorkerContentMap.put("process name", processInstance.getName());
            toleranceWorkerContentMap.put("task name", taskInstance.getName());
            toleranceWorkerContentMap.put("host", taskInstance.getHost());
            toleranceWorkerContentMap.put("task retry times", String.valueOf(taskInstance.getRetryTimes()));
            toleranceTaskInstanceList.add(toleranceWorkerContentMap);
        }
        return JSONUtils.toJson(toleranceTaskInstanceList);
    }

    public void sendAlertWorkerToleranceFault(ProcessInstance processInstance, List<TaskInstance> toleranceTaskList) {
        try {
            Alert alert = new Alert();
            alert.setTitle("worker fault tolerance");
            alert.setShowType(ShowType.TABLE);
            String content = this.getWorkerToleranceContent(processInstance, toleranceTaskList);
            alert.setContent(content);
            alert.setAlertType(AlertType.EMAIL);
            alert.setCreateTime(new Date());
            alert.setAlertGroupId(processInstance.getWarningGroupId() == null ? 1 : processInstance.getWarningGroupId());
            alert.setReceivers(processInstance.getProcessDefinition().getReceivers());
            alert.setReceiversCc(processInstance.getProcessDefinition().getReceiversCc());
            this.alertDao.addAlert(alert);
            logger.info("add alert to db , alert : {}", (Object)alert.toString());
        }
        catch (Exception e) {
            logger.error("send alert failed! " + e);
        }
    }

    public void sendAlertProcessInstance(ProcessInstance processInstance, List<TaskInstance> taskInstances) {
        boolean sendWarnning = false;
        WarningType warningType = processInstance.getWarningType();
        switch (warningType) {
            case ALL: {
                if (!processInstance.getState().typeIsFinished()) break;
                sendWarnning = true;
                break;
            }
            case SUCCESS: {
                if (!processInstance.getState().typeIsSuccess()) break;
                sendWarnning = true;
                break;
            }
            case FAILURE: {
                if (!processInstance.getState().typeIsFailure()) break;
                sendWarnning = true;
                break;
            }
        }
        if (!sendWarnning) {
            return;
        }
        Alert alert = new Alert();
        String cmdName = this.getCommandCnName(processInstance.getCommandType());
        String success = processInstance.getState().typeIsSuccess() ? "success" : "failed";
        alert.setTitle(cmdName + success);
        ShowType showType = processInstance.getState().typeIsSuccess() ? ShowType.TEXT : ShowType.TABLE;
        alert.setShowType(showType);
        String content = this.getContentProcessInstance(processInstance, taskInstances);
        alert.setContent(content);
        alert.setAlertType(AlertType.EMAIL);
        alert.setAlertGroupId(processInstance.getWarningGroupId().intValue());
        alert.setCreateTime(new Date());
        alert.setReceivers(processInstance.getProcessDefinition().getReceivers());
        alert.setReceiversCc(processInstance.getProcessDefinition().getReceiversCc());
        this.alertDao.addAlert(alert);
        logger.info("add alert to db , alert: {}", (Object)alert.toString());
    }

    public void sendProcessTimeoutAlert(ProcessInstance processInstance, ProcessDefinition processDefinition) {
        this.alertDao.sendProcessTimeoutAlert(processInstance, processDefinition);
    }
}

